/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork;

import mrriegel.storagenetwork.cable.BlockCable;
import mrriegel.storagenetwork.cable.TileCable;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.master.BlockMaster;
import mrriegel.storagenetwork.master.TileMaster;
import mrriegel.storagenetwork.proxy.CommonProxy;
import mrriegel.storagenetwork.registry.ModBlocks;
import mrriegel.storagenetwork.registry.ModItems;
import mrriegel.storagenetwork.request.BlockRequest;
import mrriegel.storagenetwork.request.TileRequest;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="storagenetwork", name="Simple Storage Network", updateJSON="https://raw.githubusercontent.com/PrinceOfAmber/Storage-Network/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class StorageNetwork {
    public Logger logger;
    public static final String MODID = "storagenetwork";
    public static final String MODNAME = "Simple Storage Network";
    @Mod.Instance(value="storagenetwork")
    public static StorageNetwork instance;
    @SidedProxy(clientSide="mrriegel.storagenetwork.proxy.ClientProxy", serverSide="mrriegel.storagenetwork.proxy.CommonProxy")
    public static CommonProxy proxy;
    private static long lastTime;

    public static void log(String s) {
        if (ConfigHandler.logEverything) {
            StorageNetwork.instance.logger.info(s);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @SubscribeEvent
    public void onRegistryBlock(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.master);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.request);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.kabel.func_149663_c(ModBlocks.kabel.getRegistryName().toString()));
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.storageKabel.func_149663_c(ModBlocks.storageKabel.getRegistryName().toString()));
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.exKabel.func_149663_c(ModBlocks.exKabel.getRegistryName().toString()));
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.imKabel.func_149663_c(ModBlocks.imKabel.getRegistryName().toString()));
    }

    @SubscribeEvent
    public void onRegistryEvent(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new BlockMaster.Item(ModBlocks.master).setRegistryName(ModBlocks.master.getRegistryName()));
        event.getRegistry().register(new BlockRequest.Item(ModBlocks.request).setRegistryName(ModBlocks.request.getRegistryName()));
        event.getRegistry().register(new BlockCable.ItemCable(ModBlocks.kabel).setRegistryName(ModBlocks.kabel.getRegistryName()));
        event.getRegistry().register(new BlockCable.ItemCable(ModBlocks.storageKabel).setRegistryName(ModBlocks.storageKabel.getRegistryName()));
        event.getRegistry().register(new BlockCable.ItemCable(ModBlocks.exKabel).setRegistryName(ModBlocks.exKabel.getRegistryName()));
        event.getRegistry().register(new BlockCable.ItemCable(ModBlocks.imKabel).setRegistryName(ModBlocks.imKabel.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)ModItems.upgrade);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.remote.func_77655_b(ModItems.remote.getRegistryName().toString()));
        GameRegistry.registerTileEntity(TileCable.class, (String)"tileKabel");
        GameRegistry.registerTileEntity(TileMaster.class, (String)"tileMaster");
        GameRegistry.registerTileEntity(TileRequest.class, (String)"tileRequest");
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        int i;
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.kabel), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:kabel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.exKabel), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:ex_kabel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.storageKabel), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:storage_kabel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.imKabel), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:im_kabel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.master), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:master", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.request), (int)0, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:request", "inventory"));
        for (i = 0; i < 4; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.upgrade, (int)i, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:upgrade_" + i, "inventory"));
        }
        for (i = 0; i < 2; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.remote, (int)i, (ModelResourceLocation)new ModelResourceLocation("storagenetwork:remote_" + i, "inventory"));
        }
    }

    public static void benchmark(String s) {
        long now = System.currentTimeMillis();
        long DIFF = now - lastTime;
        lastTime = now;
        StorageNetwork.log(now + " [" + DIFF + "] : " + s);
    }
}

