/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.tammodized.common.particles.ParticleHelper;
import tamaized.tammodized.common.particles.ParticlePacketHandlerRegistry;
import tamaized.tammodized.common.particles.TamParticle;

public class ClientPacketHandlerParticle
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, EntityPlayer player, World world) {
        if (message.custom) {
            ParticleHelper.spawnParticle(message.particle);
        } else {
            ParticleHelper.spawnParticle(world, EnumParticleTypes.func_179342_a((int)message.handlerID), message.vec, message.vel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerParticle.processPacket(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private TamParticle particle;
        private boolean custom;
        private int handlerID;
        private Vec3d vec;
        private Vec3d vel;
        private ParticleHelper.ParticlePacketHelper helper;

        public Packet() {
        }

        public Packet(int handler, Vec3d pos, ParticleHelper.ParticlePacketHelper helper) {
            this.custom = true;
            this.handlerID = handler;
            this.vec = pos;
            this.helper = helper;
        }

        public Packet(int particle, Vec3d pos, Vec3d vel) {
            this.custom = false;
            this.handlerID = particle;
            this.vec = pos;
            this.vel = vel;
        }

        public void fromBytes(ByteBuf buf) {
            this.custom = buf.readBoolean();
            this.handlerID = buf.readInt();
            this.vec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            if (this.custom) {
                this.particle = ParticlePacketHandlerRegistry.getHandler(this.handlerID).decode(buf, Minecraft.func_71410_x().field_71441_e, this.vec);
            } else {
                this.vel = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.custom);
            buf.writeInt(this.handlerID);
            buf.writeDouble(this.vec.field_72450_a);
            buf.writeDouble(this.vec.field_72448_b);
            buf.writeDouble(this.vec.field_72449_c);
            if (this.custom) {
                this.helper.encode(buf);
            } else {
                buf.writeDouble(this.vel.field_72450_a);
                buf.writeDouble(this.vel.field_72448_b);
                buf.writeDouble(this.vel.field_72449_c);
            }
        }
    }
}

