/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.compat;

import com.rwtema.funkylocomotion.compat.ModCompat;
import java.util.Map;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public abstract class CompatHandler {
    public static void initCompat(ASMDataTable asmData) {
        for (ASMDataTable.ASMData data : asmData.getAll(ModCompat.class.getName())) {
            boolean flag;
            boolean hasClassname;
            Map annotationInfo = data.getAnnotationInfo();
            String modid = annotationInfo.getOrDefault("modid", "").toString();
            String classname = annotationInfo.getOrDefault("classname", "").toString();
            boolean hasModID = !StringUtils.func_151246_b((String)modid);
            boolean bl = hasClassname = !StringUtils.func_151246_b((String)classname);
            if (!hasModID && !hasClassname) {
                throw new IllegalStateException("Both Mod ID and classname are blank");
            }
            boolean bl2 = flag = hasModID && (Loader.isModLoaded((String)modid) || ModAPIManager.INSTANCE.hasAPI(modid));
            if (!flag && hasClassname) {
                try {
                    Class.forName(classname);
                    flag = true;
                }
                catch (ClassNotFoundException ignore) {
                    flag = false;
                }
            }
            if (!flag) continue;
            try {
                Class<?> name = Class.forName(data.getClassName());
                CompatHandler compatHandler = (CompatHandler)name.newInstance();
                compatHandler.init();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public abstract void init();
}

