/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.funkylocomotion.api.IAdvStickyBlock;
import com.rwtema.funkylocomotion.blocks.BlockFLMultiState;
import com.rwtema.funkylocomotion.blocks.FLBlocks;
import com.rwtema.funkylocomotion.helper.NullHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMassFrameEdge
extends BlockFLMultiState
implements IAdvStickyBlock {
    public static final HashMap<EnumFacing.Axis, AxisOrNone> reverse = new HashMap();
    public static PropertyEnum<AxisOrNone> ORIENTATION = PropertyEnum.func_177709_a((String)"orientation", AxisOrNone.class);
    private final float s = 0.3125f;
    private final float e = 0.6875f;
    Map<AxisOrNone, AxisAlignedBB> bounds = ImmutableMap.builder().put((Object)AxisOrNone.NONE, (Object)new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875)).put((Object)AxisOrNone.X, (Object)new AxisAlignedBB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875)).put((Object)AxisOrNone.Y, (Object)new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875)).put((Object)AxisOrNone.Z, (Object)new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0)).build();

    public BlockMassFrameEdge() {
        super(Material.field_151576_e);
        this.setRegistryName("funkylocomotion:mass_frame_edge");
        this.func_149663_c("funkylocomotion:mass_frame_edge");
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds.get(this.func_176221_a(state, source, pos).func_177229_b(ORIENTATION));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORIENTATION});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing.Axis axis = null;
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState blockState = worldIn.func_180495_p(pos.func_177972_a(facing));
            Block block = blockState.func_177230_c();
            if (block != this && block != NullHelper.notNull(FLBlocks.MASS_FRAME_CORNER)) continue;
            if (axis == null) {
                axis = facing.func_176740_k();
                continue;
            }
            if (axis == facing.func_176740_k()) continue;
            axis = null;
            break;
        }
        return state.func_177226_a(ORIENTATION, (Comparable)((Object)reverse.get(axis)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public Iterable<BlockPos> getBlocksToMove(World world, BlockPos pos) {
        ImmutableList.Builder builder = ImmutableList.builder();
        EnumFacing.Axis axis = null;
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offset = pos.func_177972_a(facing);
            Block block = world.func_180495_p(offset).func_177230_c();
            if (block != this && block != NullHelper.notNull(FLBlocks.MASS_FRAME_CORNER)) continue;
            if (axis == null || axis == facing.func_176740_k()) {
                builder.add((Object)offset);
                axis = facing.func_176740_k();
                continue;
            }
            return ImmutableList.of();
        }
        return builder.build();
    }

    static {
        for (AxisOrNone axisOrNone : AxisOrNone.values()) {
            reverse.put(axisOrNone.axis, axisOrNone);
        }
    }

    public static enum AxisOrNone implements IStringSerializable
    {
        X(EnumFacing.Axis.X),
        Y(EnumFacing.Axis.Y),
        Z(EnumFacing.Axis.Z),
        NONE(null);

        @Nullable
        public EnumFacing.Axis axis;

        private AxisOrNone(EnumFacing.Axis axis) {
            this.axis = axis;
        }

        @Nonnull
        public String func_176610_l() {
            return this.axis != null ? this.axis.func_176610_l() : "none";
        }
    }
}

