/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.command.ClientCommandBase;
import codechicken.lib.command.help.IBetterHelpCommand;
import codechicken.lib.internal.CCLLog;
import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.command.CommandException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ModelLocationInfoCommand
extends ClientCommandBase
implements IBetterHelpCommand {
    private static Map<IRegistryDelegate<Item>, TIntObjectHashMap<ModelResourceLocation>> immf_locationsCache;
    private static Map<IRegistryDelegate<Item>, TIntObjectHashMap<IBakedModel>> immf_modelsCache;
    private static Map<Item, ItemMeshDefinition> imm_shapersCache;
    private static ModelResourceLocation MODEL_MISSING;

    private static void pullCache(Minecraft mc) throws CommandException {
        try {
            if (immf_locationsCache == null || immf_modelsCache == null || imm_shapersCache == null) {
                RenderItem renderItem = mc.func_175599_af();
                ItemModelMesher mesher = renderItem.func_175037_a();
                String cls = ItemModelMesherForge.class.getName().replace(".", "/");
                String cls2 = ItemModelMesher.class.getName().replace(".", "/");
                ObfMapping locationsMapping = new ObfMapping(cls, "locations", "Ljava/util/Map;");
                ObfMapping modelsMapping = new ObfMapping(cls, "locations", "Ljava/util/Map;");
                ObfMapping shapersField = new ObfMapping(cls2, "field_178092_c", "Ljava/util/Map;");
                immf_locationsCache = ReflectionManager.getField(locationsMapping, mesher, Map.class);
                immf_modelsCache = ReflectionManager.getField(modelsMapping, mesher, Map.class);
                imm_shapersCache = ReflectionManager.getField(shapersField, mesher, Map.class);
            }
        }
        catch (Exception e) {
            CCLLog.log(Level.ERROR, e, (Object)"Unable to pull cache.");
            throw new CommandException("Unable to update cache, see log.", new Object[0]);
        }
    }

    @Override
    public void execute(Minecraft mc, EntityPlayerSP player, String[] args) throws CommandException {
        ModelLocationInfoCommand.pullCache(mc);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() && (stack = player.func_184592_cb()).func_190926_b()) {
            player.func_145747_a((ITextComponent)new TextComponentString("You do not appear to be holding anything."));
            return;
        }
        Item item = stack.func_77973_b();
        ModelResourceLocation loc = null;
        if (immf_modelsCache.containsKey(item.delegate)) {
            loc = (ModelResourceLocation)immf_locationsCache.get(item.delegate).get(stack.func_77958_k() > 0 ? 0 : stack.func_77960_j());
        } else {
            ItemMeshDefinition mesher = imm_shapersCache.get(item);
            if (mesher != null) {
                loc = mesher.func_178113_a(stack);
            }
        }
        if (loc == null) {
            loc = MODEL_MISSING;
        }
        String itemLoc = loc.toString();
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "ItemModel: " + TextFormatting.RESET + itemLoc));
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            BlockStateMapper stateMapper = mc.func_175602_ab().func_175023_a().func_178120_a();
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "IBlockState assignments" + TextFormatting.RESET + ":"));
            for (Map.Entry entry : stateMapper.func_188181_b(block).entrySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + " " + entry.getKey()));
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "  " + entry.getValue()));
            }
        }
    }

    public int func_82362_a() {
        return 0;
    }

    @Override
    public String getDesc() {
        return "Dumps model info about the item you are holding.";
    }

    @Override
    public List<String> getHelp() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Syntax: '/ccl model_loc_info'");
        lines.add("The command will the held item's current ModelResourceLocation being used.");
        lines.add("If the held item is an ItemBlock, it will dump all IBlockState <-> ModelResourceLocation assignments.");
        return lines;
    }

    public String func_71517_b() {
        return "model_info";
    }

    static {
        MODEL_MISSING = new ModelResourceLocation("builtin/missing", "missing");
    }
}

