/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block.property;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.ArrayUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyString
extends PropertyHelper<String> {
    private final Set<String> valuesSet;
    private final String[] metaLookup;

    public PropertyString(String name, Collection<String> values) {
        super(name, String.class);
        this.metaLookup = (String[])values.stream().map(String::intern).toArray(String[]::new);
        this.valuesSet = new HashSet<String>();
        Collections.addAll(this.valuesSet, this.metaLookup);
    }

    public PropertyString(String name, String ... values) {
        super(name, String.class);
        this.metaLookup = (String[])Arrays.stream(values).map(String::intern).toArray(String[]::new);
        this.valuesSet = new HashSet<String>();
        Collections.addAll(this.valuesSet, this.metaLookup);
    }

    public List<String> values() {
        return Lists.newArrayList((Object[])this.metaLookup);
    }

    @Nonnull
    public Collection<String> func_177700_c() {
        return Collections.unmodifiableSet(this.valuesSet);
    }

    @Nonnull
    public Optional<String> func_185929_b(@Nonnull String value) {
        if (this.valuesSet.contains(value)) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    @Nonnull
    public String getName(@Nonnull String value) {
        return value;
    }

    public int toMeta(String value) {
        return ArrayUtils.indexOf(this.metaLookup, value.intern());
    }

    public String fromMeta(int meta) {
        if (!MathHelper.between(0.0, meta, this.metaLookup.length)) {
            throw new IllegalArgumentException(String.format("Meta data out of bounds. Meta: %s, Lookup: %s.", meta, Joiner.on((String)",").join((Object[])this.metaLookup)));
        }
        return this.metaLookup[meta];
    }
}

