/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.utils;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import sonar.core.SonarCore;

public class BlockCoords {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String HAS_DIMENSION = "hasDimension";
    public static final String DIMENSION = "dimension";
    public static final BlockCoords EMPTY = new BlockCoords(0, 0, 0);
    private BlockPos pos;
    private int dimension;
    private boolean hasDimension;

    public BlockCoords(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.hasDimension = false;
    }

    @Deprecated
    public BlockCoords(int x, int y, int z, World world) {
        this.pos = new BlockPos(x, y, z);
        this.hasDimension = true;
        this.dimension = world.field_73011_w.getDimension();
    }

    public BlockCoords(int x, int y, int z, int dimension) {
        this.pos = new BlockPos(x, y, z);
        this.hasDimension = true;
        this.dimension = dimension;
    }

    public BlockCoords(BlockPos pos) {
        this.pos = pos;
        this.hasDimension = false;
    }

    public BlockCoords(BlockPos pos, World world) {
        this.pos = pos;
        this.hasDimension = true;
        this.dimension = world.field_73011_w.getDimension();
    }

    public BlockCoords(BlockPos pos, int dimension) {
        this.pos = pos;
        this.hasDimension = true;
        this.dimension = dimension;
    }

    public BlockCoords(TileEntity tile) {
        this.pos = tile.func_174877_v();
        if (tile.func_145831_w() == null) {
            this.hasDimension = false;
        } else {
            this.hasDimension = true;
            this.dimension = tile.func_145831_w().field_73011_w.getDimension();
        }
    }

    public BlockCoords(TileEntity tile, int dimension) {
        this.pos = tile.func_174877_v();
        this.hasDimension = true;
        this.dimension = dimension;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public void setX(int x) {
        this.pos = new BlockPos(x, this.pos.func_177956_o(), this.pos.func_177952_p());
    }

    public void setY(int y) {
        this.pos = new BlockPos(this.pos.func_177958_n(), y, this.pos.func_177952_p());
    }

    public void setZ(int z) {
        this.pos = new BlockPos(this.pos.func_177958_n(), this.pos.func_177956_o(), z);
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean hasDimension() {
        return this.hasDimension;
    }

    public Block getBlock(World world) {
        return world.func_180495_p(this.pos).func_177230_c();
    }

    public TileEntity getTileEntity(World world) {
        return world.func_175625_s(this.pos);
    }

    public Block getBlock() {
        if (this.hasDimension()) {
            return this.getWorld().func_180495_p(this.pos).func_177230_c();
        }
        return null;
    }

    public IBlockState getBlockState(World world) {
        return world.func_180495_p(this.pos);
    }

    public IBlockState getBlockState() {
        if (this.hasDimension()) {
            return this.getWorld().func_180495_p(this.pos);
        }
        return null;
    }

    public TileEntity getTileEntity() {
        if (this.hasDimension()) {
            return this.getWorld().func_175625_s(this.pos);
        }
        return null;
    }

    public World getWorld() {
        return SonarCore.proxy.getDimension(this.getDimension());
    }

    public boolean insideChunk(ChunkPos pos) {
        return pos.field_77276_a >> 4 == this.getX() >> 4 && pos.field_77275_b >> 4 == this.getZ() >> 4;
    }

    public boolean insideChunk(int chunkX, int chunkZ) {
        return chunkX == this.getX() >> 4 && chunkZ == this.getZ() >> 4;
    }

    public boolean isChunkLoaded(World world) {
        return world.func_175668_a(this.pos, false);
    }

    public boolean isChunkLoaded() {
        return this.getWorld().func_175668_a(this.pos, false);
    }

    public static void writeToBuf(ByteBuf tag, BlockCoords coords) {
        tag.writeInt(coords.pos.func_177958_n());
        tag.writeInt(coords.pos.func_177956_o());
        tag.writeInt(coords.pos.func_177952_p());
        tag.writeInt(coords.dimension);
    }

    public static BlockCoords readFromBuf(ByteBuf tag) {
        return new BlockCoords(tag.readInt(), tag.readInt(), tag.readInt(), tag.readInt());
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound tag, BlockCoords coords) {
        tag.func_74768_a(X, coords.getX());
        tag.func_74768_a(Y, coords.getY());
        tag.func_74768_a(Z, coords.getZ());
        tag.func_74757_a(HAS_DIMENSION, coords.hasDimension);
        tag.func_74768_a(DIMENSION, coords.dimension);
        return tag;
    }

    public static boolean hasCoords(NBTTagCompound tag) {
        return tag.func_74764_b(X) && tag.func_74764_b(Y) && tag.func_74764_b(Z);
    }

    public static BlockCoords readFromNBT(NBTTagCompound tag) {
        if (tag.func_74767_n(HAS_DIMENSION)) {
            return new BlockCoords(tag.func_74762_e(X), tag.func_74762_e(Y), tag.func_74762_e(Z), tag.func_74762_e(DIMENSION));
        }
        return new BlockCoords(tag.func_74762_e(X), tag.func_74762_e(Y), tag.func_74762_e(Z));
    }

    public static NBTTagCompound writeBlockCoords(NBTTagCompound tag, List<BlockCoords> coords, String tagName) {
        NBTTagList list = new NBTTagList();
        if (coords != null) {
            for (BlockCoords coord : coords) {
                if (coord == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                BlockCoords.writeToNBT(compound, coord);
                list.func_74742_a((NBTBase)compound);
            }
        }
        tag.func_74782_a(tagName, (NBTBase)list);
        return tag;
    }

    public static NBTTagCompound writeBlockCoords(NBTTagCompound tag, BlockCoords[] coords) {
        NBTTagList list = new NBTTagList();
        if (coords != null) {
            for (int i = 0; i < coords.length; ++i) {
                if (coords[i] == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                BlockCoords.writeToNBT(compound, coords[i]);
                list.func_74742_a((NBTBase)compound);
            }
        }
        tag.func_74782_a("BlockCoords", (NBTBase)list);
        return tag;
    }

    public static ArrayList<BlockCoords> readBlockCoords(NBTTagCompound tag, String tagName) {
        ArrayList<BlockCoords> coords = new ArrayList<BlockCoords>();
        if (tag.func_74764_b(tagName)) {
            NBTTagList list = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                coords.add(BlockCoords.readFromNBT(compound));
            }
        }
        return coords;
    }

    public static BlockCoords[] readBlockCoords(NBTTagCompound tag, int listSize) {
        NBTTagList list = tag.func_150295_c("BlockCoords", 10);
        BlockCoords[] coords = new BlockCoords[listSize];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= listSize) continue;
            coords[b] = BlockCoords.readFromNBT(compound);
        }
        return coords;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockCoords)) {
            return false;
        }
        BlockCoords coords = (BlockCoords)obj;
        return this.pos.func_177958_n() == coords.pos.func_177958_n() && this.pos.func_177956_o() == coords.pos.func_177956_o() && this.pos.func_177952_p() == coords.pos.func_177952_p() && this.dimension == coords.dimension;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.hasDimension ? 0 : 1);
        result = 37 * result + this.pos.func_177958_n();
        result = 37 * result + this.pos.func_177956_o();
        result = 37 * result + this.pos.func_177952_p();
        result = 37 * result + this.dimension;
        return result;
    }

    public static boolean equalCoords(BlockCoords coords1, BlockCoords coords2) {
        return coords1 == null && coords2 == null || coords1 == null || coords2 != null && (coords2 == null || coords1.pos.func_177958_n() == coords2.pos.func_177958_n() && coords1.pos.func_177956_o() == coords2.pos.func_177956_o() && coords1.pos.func_177952_p() == coords2.pos.func_177952_p() && coords1.dimension == coords2.dimension);
    }

    public static boolean equalCoordArrays(BlockCoords[] coords1, BlockCoords[] coords2) {
        if (coords1.length != coords2.length) {
            return false;
        }
        for (int i = 0; i < coords1.length; ++i) {
            if (BlockCoords.equalCoords(coords1[i], coords2[i])) continue;
            return false;
        }
        return true;
    }

    public static BlockCoords translateCoords(BlockCoords coords, EnumFacing dir) {
        return new BlockCoords(coords.getX() + dir.func_82601_c(), coords.getY() + dir.func_96559_d(), coords.getZ() + dir.func_82599_e(), coords.dimension);
    }

    public String toString() {
        return "X: " + this.getX() + " Y: " + this.getY() + " Z: " + this.getZ() + " D: " + this.dimension;
    }

    public BlockCoords fromString(String string) {
        String[] split = string.split(": ");
        int x = Integer.parseInt(split[1]);
        int y = Integer.parseInt(split[3]);
        int z = Integer.parseInt(split[5]);
        int d = Integer.parseInt(split[7]);
        return new BlockCoords(x, y, z, d);
    }

    public boolean contains(Map<BlockCoords, ?> map) {
        for (Map.Entry<BlockCoords, ?> set : map.entrySet()) {
            if (!set.getKey().equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(List<BlockCoords> list) {
        for (BlockCoords coords : list) {
            if (!coords.equals(this)) continue;
            return true;
        }
        return false;
    }
}

