/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.proxy;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.entity.RenderProjectile;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamite;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamiteBlockSafe;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamiteMining;
import com.lothrazar.cyclicmagic.item.endereye.EntityEnderEyeUnbreakable;
import com.lothrazar.cyclicmagic.item.findspawner.EntityDungeonEye;
import com.lothrazar.cyclicmagic.item.firemagic.EntityBlazeBolt;
import com.lothrazar.cyclicmagic.item.fishing.EntityFishingBolt;
import com.lothrazar.cyclicmagic.item.homingmissile.EntityHomingProjectile;
import com.lothrazar.cyclicmagic.item.lightningmagic.EntityLightningballBolt;
import com.lothrazar.cyclicmagic.item.minecart.EntityGoldFurnaceMinecart;
import com.lothrazar.cyclicmagic.item.minecart.EntityGoldMinecart;
import com.lothrazar.cyclicmagic.item.minecart.EntityMinecartTurret;
import com.lothrazar.cyclicmagic.item.minecart.EntityStoneMinecart;
import com.lothrazar.cyclicmagic.item.minecart.RenderCyclicMinecart;
import com.lothrazar.cyclicmagic.item.mobcapture.EntityMagicNetEmpty;
import com.lothrazar.cyclicmagic.item.mobcapture.EntityMagicNetFull;
import com.lothrazar.cyclicmagic.item.shears.EntityShearingBolt;
import com.lothrazar.cyclicmagic.item.slingshot.EntitySlingshot;
import com.lothrazar.cyclicmagic.item.snowmagic.EntitySnowballBolt;
import com.lothrazar.cyclicmagic.item.storagesack.ItemStorageBag;
import com.lothrazar.cyclicmagic.item.torchmagic.EntityTorchBolt;
import com.lothrazar.cyclicmagic.module.ItemModule;
import com.lothrazar.cyclicmagic.module.KeyInventoryShiftModule;
import com.lothrazar.cyclicmagic.particle.ParticleRenderer;
import com.lothrazar.cyclicmagic.proxy.CommonProxy;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    public static ParticleRenderer particleRenderer = new ParticleRenderer();
    public static KeyBinding keyShiftUp;
    public static KeyBinding keyShiftDown;
    public static KeyBinding keyBarUp;
    public static KeyBinding keyBarDown;
    public static KeyBinding keyExtraInvo;
    public static KeyBinding keyExtraCraftin;
    static final String keyCategoryInventory = "key.categories.inventorycontrol";
    public static final String[] NET_CLIENT_HANDLER;

    @Override
    public void preInit() {
        this.registerEntities();
    }

    @Override
    public void init() {
        this.registerKeys();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void registerKeys() {
        if (KeyInventoryShiftModule.enableInvoKeys) {
            keyShiftUp = new KeyBinding("key.columnshiftup", 21, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftUp);
            keyShiftDown = new KeyBinding("key.columnshiftdown", 35, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftDown);
            keyBarUp = new KeyBinding("key.columnbarup", 26, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarUp);
            keyBarDown = new KeyBinding("key.columnbardown", 27, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarDown);
            keyExtraInvo = new KeyBinding("key.keyExtraInvo", 19, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyExtraInvo);
            keyExtraCraftin = new KeyBinding("key.keyExtraCraftin", 24, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyExtraCraftin);
        }
    }

    private void registerEntities() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_GOLD);
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldFurnaceMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_GOLD_FURNACE);
        RenderingRegistry.registerEntityRenderingHandler(EntityStoneMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_STONE_FURNACE);
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartTurret.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_TURRET);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningballBolt.class, (IRenderFactory)new EntityLightningballBolt.FactoryLightning());
        RenderingRegistry.registerEntityRenderingHandler(EntitySnowballBolt.class, (IRenderFactory)new EntitySnowballBolt.FactorySnow());
        RenderingRegistry.registerEntityRenderingHandler(EntityTorchBolt.class, (IRenderFactory)new EntityTorchBolt.FactoryTorch());
        RenderingRegistry.registerEntityRenderingHandler(EntityFishingBolt.class, (IRenderFactory)new EntityFishingBolt.FactoryFish());
        RenderingRegistry.registerEntityRenderingHandler(EntityShearingBolt.class, (IRenderFactory)new EntityShearingBolt.FactoryShear());
        RenderingRegistry.registerEntityRenderingHandler(EntityDungeonEye.class, (IRenderFactory)new EntityDungeonEye.FactoryDungeon());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (IRenderFactory)new EntityDynamite.FactoryDyn());
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeBolt.class, (IRenderFactory)new EntityBlazeBolt.FactoryFire());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamiteMining.class, (IRenderFactory)new RenderProjectile.FactoryDynMining());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamiteBlockSafe.class, (IRenderFactory)new RenderProjectile.FactoryDynSafe());
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicNetFull.class, (IRenderFactory)new EntityMagicNetFull.FactoryBall());
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicNetEmpty.class, (IRenderFactory)new EntityMagicNetEmpty.FactoryBallEmpty());
        RenderingRegistry.registerEntityRenderingHandler(EntityHomingProjectile.class, (IRenderFactory)new EntityHomingProjectile.FactoryMissile());
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderEyeUnbreakable.class, (IRenderFactory)new EntityEnderEyeUnbreakable.FactoryMissile());
        RenderingRegistry.registerEntityRenderingHandler(EntitySlingshot.class, (IRenderFactory)new EntitySlingshot.FactoryFire());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumFacing getSideMouseover(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.field_178784_b;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverSingle() {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return null;
        }
        return mouseOver.func_178782_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverExact(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.func_178782_a();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverOffset(int max) {
        BlockPos blockPos;
        EntityPlayerSP player = (EntityPlayerSP)this.getClientPlayer();
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null && mouseOver.field_178784_b != null && (blockPos = mouseOver.func_178782_a()) != null && player != null && player.func_130014_f_().func_180495_p(blockPos) != null && !player.func_130014_f_().func_175623_d(blockPos)) {
            return blockPos.func_177972_a(mouseOver.field_178784_b);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClientPlayerData(MessageContext ctx, NBTTagCompound tags) {
        CapabilityRegistry.IPlayerExtendedProperties props;
        EntityPlayer player = this.getPlayerEntity(ctx);
        if (player != null && (props = CapabilityRegistry.getPlayerProperties(this.getClientPlayer())) != null) {
            props.setDataFromNBT(tags);
            if (props.getMaxHealth() != 0 && (float)props.getMaxHealth() > player.func_110138_aP()) {
                UtilEntity.setMaxHealth((EntityLivingBase)player, props.getMaxHealth());
            }
        }
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.getClientPlayer() : super.getPlayerEntity(ctx);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnScreen(ItemStack current, int x, int y) {
        if (current == null) {
            return;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        itemRender.func_180450_b(current, x, y);
        RenderHelper.func_74518_a();
    }

    @Override
    public void renderItemOnGui(ItemStack stack, RenderItem itemRender, FontRenderer fontRendererObj, int x, int y) {
        if (stack == null) {
            return;
        }
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_175030_a(fontRendererObj, stack, x, y);
    }

    @Override
    public void closeSpectatorGui() {
        try {
            Minecraft.func_71410_x().field_71456_v.func_175187_g().func_175257_a(null);
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error trying to lock out Spectator GUI: ");
            ModCyclic.logger.error(e.getMessage());
        }
    }

    @Override
    public void setPlayerReach(EntityPlayer player, int currentReach) {
        super.setPlayerReach(player, currentReach);
        Minecraft mc = Minecraft.func_71410_x();
        try {
            if (player == mc.field_71439_g) {
                if (mc.field_71442_b instanceof ReachPlayerController) {
                    ((ReachPlayerController)mc.field_71442_b).setReachDistance(currentReach);
                } else {
                    NetHandlerPlayClient netHandler = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])NET_CLIENT_HANDLER);
                    ReachPlayerController controller = new ReachPlayerController(mc, netHandler);
                    controller.func_78746_a(mc.field_71442_b.func_178889_l());
                    player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b;
                    player.field_71075_bZ.field_75101_c = player.field_71075_bZ.field_75101_c;
                    mc.field_71442_b = controller;
                    controller.setReachDistance(currentReach);
                }
            }
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error setting reach : " + e.getMessage());
        }
    }

    @Override
    public void initColors() {
        if (ItemModule.storage_bag != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
                if (tintIndex == 0) {
                    return -1;
                }
                return ItemStorageBag.StorageActionType.getColour(stack);
            }, new Item[]{ItemModule.storage_bag});
        }
    }

    static {
        NET_CLIENT_HANDLER = new String[]{"connection", "field_78774_b"};
    }

    @SideOnly(value=Side.CLIENT)
    public class ReachPlayerController
    extends PlayerControllerMP {
        private float distance;

        public ReachPlayerController(Minecraft mcIn, NetHandlerPlayClient netHandler) {
            super(mcIn, netHandler);
            this.distance = 0.0f;
        }

        public float func_78757_d() {
            return this.distance;
        }

        public void setReachDistance(float f) {
            this.distance = f;
        }
    }
}

