/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.potion;

import com.lothrazar.cyclicmagic.module.ItemPotionModule;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.potion.PotionTypeCyclic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionTypeRegistry {
    public static List<PotionTypeCyclic> potions = new ArrayList<PotionTypeCyclic>();
    private static PotionTypeCyclic potionTypeSlowfall;
    private static PotionTypeCyclic potionTypeBounce;
    private static PotionTypeCyclic potionTypeWaterwalk;
    private static PotionTypeCyclic potionTypeSnow;
    private static PotionTypeCyclic potionTypeSwim;
    private static PotionTypeCyclic potionTypeMagnet;
    private static PotionTypeCyclic potionTypeLevitation;
    private static PotionTypeCyclic potionTypeHaste;
    private static PotionTypeCyclic potionTypeResistance;
    private static PotionTypeCyclic potionTypeResistanceII;
    private static PotionTypeCyclic potionHealth;
    private static PotionTypeCyclic potionEnder;
    private static PotionTypeCyclic potionTypeLuck;
    private static PotionTypeCyclic potionTypeWither;
    private static PotionTypeCyclic potionTypeBlindness;
    private static PotionTypeCyclic potionTypeSat;
    private static PotionTypeCyclic potionTypeIce;
    private static PotionTypeCyclic potionTypeButter;
    private static PotionTypeCyclic potionTypeButterII;
    private static final int SHORT = 1800;
    private static final int NORMAL = 3600;

    public static void register() {
        if (ItemPotionModule.enableButter) {
            potionTypeButter = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.DROPS, 3600), "butter", new ItemStack(Items.field_151043_k));
            potions.add(potionTypeButter);
            potionTypeButterII = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.DROPS, 1800, 1), "butter2", Item.func_150898_a((Block)Blocks.field_150405_ch));
            PotionTypeRegistry.potionTypeButterII.base = potionTypeButter;
            potions.add(potionTypeButterII);
        }
        if (ItemPotionModule.enableSlowfall) {
            potionTypeSlowfall = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.SLOWFALL, 3600), "slowfall", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()));
            potions.add(potionTypeSlowfall);
        }
        if (ItemPotionModule.enableWaterwalk) {
            potionTypeWaterwalk = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.WATERWALK, 3600), "waterwalk", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()));
            potions.add(potionTypeWaterwalk);
        }
        if (ItemPotionModule.enableSnow) {
            potionTypeSnow = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.SNOW, 3600), "snow", Items.field_151126_ay);
            potions.add(potionTypeSnow);
        }
        if (ItemPotionModule.enableSwimspeed) {
            potionTypeSwim = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.SWIMSPEED, 3600), "swim", Items.field_151146_bM);
            potions.add(potionTypeSwim);
        }
        if (ItemPotionModule.enableBounce) {
            potionTypeBounce = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.BOUNCE, 3600), "bounce", Items.field_151123_aH);
            potions.add(potionTypeBounce);
        }
        if (ItemPotionModule.enableFrostw) {
            potionTypeIce = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.FROSTW, 3600), "frostwalker", new ItemStack(Blocks.field_150432_aD));
            potions.add(potionTypeIce);
        }
        if (ItemPotionModule.enableMagnet) {
            potionTypeMagnet = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.MAGNET, 3600), "magnet", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
            potions.add(potionTypeMagnet);
        }
        if (ItemPotionModule.enableLevit) {
            potionTypeLevitation = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_188424_y, 3600), "levitation", Items.field_185161_cS);
            potions.add(potionTypeLevitation);
        }
        if (ItemPotionModule.enableHaste) {
            potionTypeHaste = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76422_e, 3600), "haste", Items.field_151106_aX);
            potions.add(potionTypeHaste);
            PotionTypeCyclic potionTypeHasteII = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76422_e, 1800, 1), "haste2", Items.field_151114_aO);
            potionTypeHasteII.base = potionTypeHaste;
            potions.add(potionTypeHasteII);
        }
        if (ItemPotionModule.enableResist) {
            potionTypeResistance = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76429_m, 3600), "resistance", new ItemStack(Blocks.field_150343_Z));
            potions.add(potionTypeResistance);
            potionTypeResistanceII = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76429_m, 1800, 1), "resistance2", Items.field_151114_aO);
            PotionTypeRegistry.potionTypeResistanceII.base = potionTypeResistance;
            potions.add(potionTypeResistanceII);
        }
        if (ItemPotionModule.enableHBoost) {
            potionHealth = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_180152_w, 3600, 4), "healthboost", Items.field_151153_ao);
            potions.add(potionHealth);
        }
        if (ItemPotionModule.enableEnder) {
            potionEnder = PotionTypeRegistry.addPotionType(new PotionEffect((Potion)PotionEffectRegistry.ENDER, 3600), "ender", Items.field_151079_bi);
            potions.add(potionEnder);
        }
        if (ItemPotionModule.enableLuck) {
            potionTypeLuck = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_188425_z, 3600), "luck", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()));
            potions.add(potionTypeLuck);
        }
        if (ItemPotionModule.enableWither) {
            potionTypeWither = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_82731_v, 3600), "wither", Items.field_151071_bq);
            PotionTypeRegistry.potionTypeWither.base = PotionTypes.field_185226_I;
            potions.add(potionTypeWither);
        }
        if (ItemPotionModule.enableBlindness) {
            potionTypeBlindness = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76440_q, 3600), "blindness", Items.field_151071_bq);
            PotionTypeRegistry.potionTypeBlindness.base = PotionTypes.field_185236_h;
            potions.add(potionTypeBlindness);
        }
        if (ItemPotionModule.enableSaturation) {
            potionTypeSat = PotionTypeRegistry.addPotionType(new PotionEffect(MobEffects.field_76443_y, 3600), "saturation", Items.field_151105_aU);
            PotionTypeRegistry.potionTypeSat.base = PotionTypes.field_185250_v;
            potions.add(potionTypeSat);
        }
    }

    private static PotionTypeCyclic addPotionType(PotionEffect eff, String name, ItemStack item) {
        return new PotionTypeCyclic(name, new PotionEffect[]{eff}, item);
    }

    private static PotionTypeCyclic addPotionType(PotionEffect eff, String name, Item item) {
        return PotionTypeRegistry.addPotionType(eff, name, new ItemStack(item));
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegistryEvent.Register<PotionType> event) {
        PotionTypeRegistry.register();
        for (PotionTypeCyclic pt : potions) {
            event.getRegistry().register((IForgeRegistryEntry)pt);
            pt.addMix();
        }
    }
}

