/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.playerupgrade.storage;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.gui.InventoryBase;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.playerupgrade.PacketSyncExtendedInventory;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InventoryPlayerExtended
extends InventoryBase
implements IInventory {
    private Container eventHandler;
    public WeakReference<EntityPlayer> player;
    public static final int IROW = 4;
    public static final int ICOL = 9;

    public InventoryPlayerExtended(EntityPlayer player) {
        super(56);
        this.player = new WeakReference<EntityPlayer>(player);
    }

    public Container getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(Container eventHandler) {
        this.eventHandler = eventHandler;
    }

    public ITextComponent func_145748_c_() {
        ITextComponent name = super.getDisplayName();
        if (name == null) {
            return new TextComponentTranslation("cyclic.inventory.extended", new Object[0]);
        }
        return name;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack r = super.decrStackSize(index, count);
        this.syncSlotToClients(index);
        return r;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.setInventorySlotContents(index, stack);
        this.syncSlotToClients(index);
    }

    public int func_70302_i_() {
        return this.inv.size();
    }

    public ItemStack func_70301_a(int s) {
        try {
            return s >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.inv.get(s);
        }
        catch (Exception e) {
            ModCyclic.logger.error("[getStackInSlot] error: " + s);
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        try {
            ((EntityPlayer)this.player.get()).field_71071_by.func_70296_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.size(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void saveNBT(EntityPlayer player) {
        NBTTagCompound tags = player.getEntityData();
        this.saveNBT(tags);
    }

    public void saveNBT(NBTTagCompound tags) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inv.size(); ++i) {
            if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inv.get(i)).func_77955_b(invSlot);
            tagList.func_74742_a((NBTBase)invSlot);
        }
        tags.func_74782_a("cyclicmagic.Inventory", (NBTBase)tagList);
    }

    public void readNBT(EntityPlayer player) {
        NBTTagCompound tags = player.getEntityData();
        this.readNBT(tags);
    }

    public void readNBT(NBTTagCompound tags) {
        NBTTagList tagList = tags.func_150295_c("cyclicmagic.Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = UtilNBT.itemFromNBT(nbttagcompound);
            if (itemstack.func_190926_b()) continue;
            this.inv.set(j, (Object)itemstack);
        }
    }

    public void dropItems(List<EntityItem> drops, BlockPos pos) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
            World world = ((EntityPlayer)this.player.get()).func_130014_f_();
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ItemStack)this.inv.get(i)).func_77946_l());
            ei.func_174867_a(40);
            float f1 = world.field_73012_v.nextFloat() * 0.5f;
            float f2 = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            drops.add(ei);
            this.inv.set(i, (Object)ItemStack.field_190927_a);
            this.syncSlotToClients(i);
        }
    }

    public void syncSlotToClients(int slot) {
        try {
            if (ModCyclic.proxy.getClientWorld() == null) {
                ModCyclic.network.sendToAll((IMessage)new PacketSyncExtendedInventory((EntityPlayer)this.player.get(), slot));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_191420_l() {
        return false;
    }
}

