/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.firemagic;

import com.lothrazar.cyclicmagic.core.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityBlazeBolt
extends EntityThrowableDispensable {
    static final float damage = 10.0f;
    public static final int fireSeconds = 4;

    public EntityBlazeBolt(World worldIn) {
        super(worldIn);
    }

    public EntityBlazeBolt(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntityBlazeBolt(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        if (mop.field_72308_g != null && (mop.field_72308_g.isCreatureType(EnumCreatureType.MONSTER, false) || mop.field_72308_g instanceof EntityPlayer)) {
            mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 10.0f);
            mop.field_72308_g.func_70015_d(4);
            this.func_70106_y();
            return;
        }
        BlockPos pos = mop.func_178782_a();
        BlockPos offset = null;
        if (pos == null) {
            return;
        }
        ArrayList<Object> waterBoth = new ArrayList<Object>();
        waterBoth.add(Blocks.field_150358_i);
        waterBoth.add(Blocks.field_150355_j);
        World world = this.func_130014_f_();
        if (mop.field_178784_b != null && this.func_85052_h() instanceof EntityPlayer) {
            offset = mop.func_178782_a().func_177972_a(mop.field_178784_b);
        }
        if (mop.field_178784_b != null) {
            offset = pos.func_177972_a(mop.field_178784_b);
        }
        ArrayList<BlockPos> toSetFire = new ArrayList<BlockPos>();
        if (!this.func_70090_H()) {
            if (world.func_175623_d(pos)) {
                toSetFire.add(pos);
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.EAST))) {
                toSetFire.add(pos.func_177972_a(EnumFacing.EAST));
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.NORTH))) {
                toSetFire.add(pos.func_177972_a(EnumFacing.NORTH));
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.SOUTH))) {
                toSetFire.add(pos.func_177972_a(EnumFacing.SOUTH));
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.WEST))) {
                toSetFire.add(pos.func_177972_a(EnumFacing.WEST));
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
                toSetFire.add(pos.func_177972_a(EnumFacing.UP));
            }
            if (offset != null && world.func_175623_d(offset)) {
                toSetFire.add(offset);
                if (world.func_175623_d(offset.func_177972_a(EnumFacing.EAST))) {
                    toSetFire.add(offset.func_177972_a(EnumFacing.EAST));
                }
                if (world.func_175623_d(offset.func_177972_a(EnumFacing.NORTH))) {
                    toSetFire.add(offset.func_177972_a(EnumFacing.NORTH));
                }
                if (world.func_175623_d(offset.func_177972_a(EnumFacing.SOUTH))) {
                    toSetFire.add(offset.func_177972_a(EnumFacing.SOUTH));
                }
                if (world.func_175623_d(offset.func_177972_a(EnumFacing.WEST))) {
                    toSetFire.add(offset.func_177972_a(EnumFacing.WEST));
                }
                if (world.func_175623_d(offset.func_177972_a(EnumFacing.UP))) {
                    toSetFire.add(offset.func_177972_a(EnumFacing.UP));
                }
            }
            for (BlockPos p : toSetFire) {
                world.func_175656_a(p, Block.func_149684_b((String)"cyclicmagic:fire_dark").func_176223_P());
                world.func_175688_a(EnumParticleTypes.FLAME, (double)p.func_177984_a().func_177958_n(), (double)p.func_177984_a().func_177956_o(), (double)p.func_177984_a().func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        UtilSound.playSound(world, pos, SoundRegistry.fireball_explode, SoundCategory.BLOCKS);
        this.func_70106_y();
    }

    public static class FactoryFire
    implements IRenderFactory<EntityBlazeBolt> {
        public Render<? super EntityBlazeBolt> createRenderFor(RenderManager rm) {
            RenderSnowball x = new RenderSnowball(rm, Item.func_111206_d((String)"cyclicmagic:fire_dark_anim"), Minecraft.func_71410_x().func_175599_af());
            return x;
        }
    }
}

