/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipment.crystal;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.registry.MaterialRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPowerSword
extends ItemSword
implements IHasRecipe,
IHasConfig {
    private static final int COOLDOWN = 20;
    private SwordType type;
    private boolean enableShooting;

    public ItemPowerSword(SwordType t) {
        super(MaterialRegistry.powerToolMaterial);
        this.type = t;
        this.func_77656_e(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.enableShooting) {
            tooltip.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    @Override
    public IRecipe addRecipe() {
        ItemStack item = ItemStack.field_190927_a;
        switch (this.type) {
            case WEAK: {
                item = new ItemStack((Block)Blocks.field_150391_bh);
                break;
            }
            case SLOW: {
                item = new ItemStack(Blocks.field_150403_cj);
                break;
            }
            case ENDER: {
                item = new ItemStack(Items.field_185161_cS);
            }
        }
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "ded", "ded", "wsw", Character.valueOf('w'), item, Character.valueOf('e'), Items.field_151156_bN, Character.valueOf('d'), Items.field_185157_bK, Character.valueOf('s'), "blockEmerald");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (this.enableShooting) {
            switch (this.type) {
                case WEAK: {
                    this.spawnLingeringPotion(player, PotionTypes.field_185226_I);
                    break;
                }
                case SLOW: {
                    this.spawnLingeringPotion(player, PotionTypes.field_185246_r);
                    break;
                }
                case ENDER: {
                    player.func_70690_d(new PotionEffect((Potion)PotionEffectRegistry.ENDER, 200, 0));
                    if (world.field_72995_K) break;
                    EntityEnderPearl entityenderpearl = new EntityEnderPearl(world, (EntityLivingBase)player);
                    entityenderpearl.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.6f, 1.0f);
                    world.func_72838_d((Entity)entityenderpearl);
                }
            }
            UtilSound.playSound(player, SoundEvents.field_187595_bc);
            player.func_184811_cZ().func_185145_a((Item)this, 20);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    private void spawnLingeringPotion(EntityPlayer player, PotionType ptype) {
        World world = player.func_130014_f_();
        ItemStack potion = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)ptype);
        EntityPotion entitypotion = new EntityPotion(world, (EntityLivingBase)player, potion);
        entitypotion.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.6f, 0.5f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entitypotion);
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enableShooting = config.getBoolean(this.func_77658_a().replace("item.", "") + "_projectiles", "modpacks", true, "Disable the projectile (splash potion / ender pearl) from this endgame sword");
    }

    public static enum SwordType {
        SLOW,
        WEAK,
        ENDER;

    }
}

