/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.google.common.collect.ImmutableSet;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMattock
extends ItemTool
implements IHasRecipe {
    static final int RADIUS = 1;
    private Set<Material> mats;

    public ItemMattock(float attackDamageIn, float attackSpeedIn, Item.ToolMaterial materialIn, Set<Block> effectiveBlocksIn, Set<Material> mats) {
        super(attackDamageIn, attackSpeedIn, materialIn, effectiveBlocksIn);
        this.mats = mats;
        this.func_77656_e(9000);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = new ItemStack(Blocks.field_150343_Z);
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"shovel", (Object)"pickaxe");
    }

    public boolean func_150897_b(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() == 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? (state.func_185904_a() == Material.field_151576_e ? true : (state.func_185904_a() == Material.field_151573_f ? true : state.func_185904_a() == Material.field_151574_g)) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return state.func_185904_a() != Material.field_151573_f && state.func_185904_a() != Material.field_151574_g && state.func_185904_a() != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos posHit, EntityPlayer player) {
        RayTraceResult ray = this.func_77621_a(player.func_130014_f_(), player, false);
        if (ray == null) {
            return super.onBlockStartBreak(stack, posHit, player);
        }
        EnumFacing sideHit = ray.field_178784_b;
        World world = player.func_130014_f_();
        List<BlockPos> shape = sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN ? UtilShape.squareHorizontalHollow(posHit, 1) : (sideHit == EnumFacing.EAST || sideHit == EnumFacing.WEST ? UtilShape.squareVerticalZ(posHit, 1) : UtilShape.squareVerticalX(posHit, 1));
        for (BlockPos posCurrent : shape) {
            Block blockCurrent;
            if (posHit.equals((Object)posCurrent) || super.onBlockStartBreak(stack, new BlockPos((Vec3i)posCurrent), player)) continue;
            IBlockState bsCurrent = world.func_180495_p(posCurrent);
            if (world.func_175623_d(posCurrent) || !this.mats.contains(bsCurrent.func_185904_a()) || !ForgeHooks.canHarvestBlock((Block)(blockCurrent = bsCurrent.func_177230_c()), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)posCurrent) || !bsCurrent.func_177230_c().canEntityDestroy(bsCurrent, (IBlockAccess)world, posCurrent, (Entity)player) || bsCurrent.func_177230_c().func_176195_g(bsCurrent, world, posCurrent) < 0.0f) continue;
            stack.func_179548_a(world, bsCurrent, posCurrent, player);
            if (world.field_72995_K) {
                world.func_175718_b(2001, posCurrent, Block.func_176210_f((IBlockState)bsCurrent));
                if (blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true)) {
                    blockCurrent.func_176206_d(world, posCurrent, bsCurrent);
                }
                stack.func_179548_a(world, bsCurrent, posCurrent, player);
                if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, posCurrent, Minecraft.func_71410_x().field_71476_x.field_178784_b));
                continue;
            }
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP mp = (EntityPlayerMP)player;
            int xpGivenOnDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)posCurrent);
            if (xpGivenOnDrop < 0) continue;
            if (blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true)) {
                TileEntity tile = world.func_175625_s(posCurrent);
                blockCurrent.func_176206_d(world, posCurrent, bsCurrent);
                blockCurrent.func_180657_a(world, player, posCurrent, bsCurrent, tile, stack);
                blockCurrent.func_180637_b(world, posCurrent, xpGivenOnDrop);
            }
            mp.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, posCurrent));
        }
        return super.onBlockStartBreak(stack, posHit, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack held, World player, List<String> list, ITooltipFlag par4) {
        list.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
        super.func_77624_a(held, player, list, par4);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "odo", " e ", " e ", Character.valueOf('e'), "blockQuartz", Character.valueOf('o'), "obsidian", Character.valueOf('d'), "gemDiamond");
    }
}

