/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.button;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.gui.GuiButtonTexture;
import com.lothrazar.cyclicmagic.net.PacketTileIncrementField;
import com.lothrazar.cyclicmagic.net.PacketTileSetField;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ButtonTileEntityField
extends GuiButtonTexture {
    private BlockPos pos;
    private int field;
    private int value;
    public ButtonMode buttonMode = ButtonMode.INCREMENT;

    public ButtonTileEntityField(int buttonId, int x, int y, BlockPos p, int fld) {
        this(buttonId, x, y, p, fld, 1);
    }

    public ButtonTileEntityField(int buttonId, int x, int y, BlockPos p, int fld, int diff) {
        this(buttonId, x, y, p, fld, diff, 40, 20);
    }

    public ButtonTileEntityField(int buttonId, int x, int y, BlockPos p, int fld, int diff, int w, int h) {
        super(buttonId, x, y, w, h);
        this.pos = p;
        this.field = fld;
        this.value = diff;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean pressed = super.func_146116_c(mc, mouseX, mouseY);
        if (pressed) {
            switch (this.buttonMode) {
                case INCREMENT: {
                    ModCyclic.network.sendToServer((IMessage)new PacketTileIncrementField(this.pos, this.field, this.value));
                    break;
                }
                case SET: {
                    ModCyclic.network.sendToServer((IMessage)new PacketTileSetField(this.pos, this.field, this.value));
                }
            }
        }
        return pressed;
    }

    public int getFieldId() {
        return this.field;
    }

    public int getValue() {
        return this.value;
    }

    public static enum ButtonMode {
        INCREMENT,
        SET;

    }
}

