/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.enchant;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public abstract class EnchantBase
extends Enchantment {
    protected EnchantBase(String name, Enchantment.Rarity rarityIn, EnumEnchantmentType typeIn, EntityEquipmentSlot[] slots) {
        super(rarityIn, typeIn, slots);
        this.func_77322_b(name);
    }

    protected int getCurrentLevelTool(ItemStack stack) {
        if (!stack.func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey((Object)this)) {
            return (Integer)EnchantmentHelper.func_82781_a((ItemStack)stack).get((Object)this);
        }
        return -1;
    }

    protected int getCurrentLevelTool(EntityLivingBase player) {
        if (player == null) {
            return -1;
        }
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return Math.max(this.getCurrentLevelTool(main), this.getCurrentLevelTool(off));
    }

    protected int getCurrentArmorLevel(EntityLivingBase player) {
        EntityEquipmentSlot[] armors = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS};
        int level = 0;
        for (EntityEquipmentSlot slot : armors) {
            int newlevel;
            ItemStack armor = player.func_184582_a(slot);
            if (armor.func_190926_b() || EnchantmentHelper.func_82781_a((ItemStack)armor) == null || !EnchantmentHelper.func_82781_a((ItemStack)armor).containsKey((Object)this) || (newlevel = ((Integer)EnchantmentHelper.func_82781_a((ItemStack)armor).get((Object)this)).intValue()) <= level) continue;
            level = newlevel;
        }
        return level;
    }

    protected int getLevelAll(EntityLivingBase p) {
        return Math.max(this.getCurrentArmorLevel(p), this.getCurrentLevelTool(p));
    }

    protected ItemStack getFirstArmorStackWithEnchant(EntityLivingBase player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        for (ItemStack main : player.func_184193_aE()) {
            if (main.func_190926_b() || !EnchantmentHelper.func_82781_a((ItemStack)main).containsKey((Object)this)) continue;
            return main;
        }
        return ItemStack.field_190927_a;
    }
}

