/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.block;

import com.google.common.base.Function;
import com.lothrazar.cyclicmagic.ModCyclic;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public abstract class BaseTESR<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    protected IModel model;
    protected IBakedModel bakedModel;
    protected String resource = null;

    public BaseTESR(@Nullable Block block) {
        if (block != null) {
            this.resource = "tesr/" + block.func_149739_a().replace("tile.", "").replace(".name", "");
        }
    }

    @Nullable
    protected IBakedModel getBakedModel() {
        if (this.bakedModel == null && this.resource != null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("cyclicmagic", this.resource));
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error trying to obtain baked model", e);
                return null;
            }
            this.bakedModel = this.model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, (java.util.function.Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            });
        }
        return this.bakedModel;
    }

    protected void renderItem(TileEntity te, ItemStack stack, float itemHeight) {
        this.renderItem(te, stack, 0.5f, itemHeight, 0.5f);
    }

    protected void renderItem(TileEntity te, ItemStack stack, float x, float itemHeight, float y) {
        this.renderItem(te, stack, x, itemHeight, y, 0, true, 0.4f);
    }

    protected void renderItem(TileEntity te, ItemStack stack, float x, float itemHeight, float y, int initialAngle, boolean isSpinning, float scaleFactor) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (initialAngle > 0) {
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            GlStateManager.func_179114_b((float)initialAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        }
        if (isSpinning) {
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            long angle = System.currentTimeMillis() / 10L % 360L;
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        }
        GlStateManager.func_179109_b((float)x, (float)itemHeight, (float)y);
        GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        this.fixLighting(te);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    public void fixLighting(TileEntity te) {
        int ambLight = this.func_178459_a().func_175626_b(te.func_174877_v().func_177972_a(EnumFacing.UP), 0);
        if (ambLight == 0) {
            ambLight = 0xF00010;
        }
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
    }

    public void renderTextAt(String s, double x, double y, double z, int destroyStage, float xt, float yt, float zt, float angle, int textColor) {
        boolean lightsOn = true;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        if (angle != 0.0f) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!lightsOn) {
            GlStateManager.func_179091_B();
        }
        FontRenderer fontrenderer = this.func_147498_b();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.50009f);
        GlStateManager.func_179109_b((float)xt, (float)yt, (float)zt);
        GlStateManager.func_179152_a((float)0.010416667f, (float)-0.010416667f, (float)0.010416667f);
        if (!lightsOn) {
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-0.010416667f);
        }
        GlStateManager.func_179132_a((boolean)false);
        fontrenderer.func_78276_b(s, 0, 0, textColor);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public int angleOfFace(EnumFacing side) {
        switch (side) {
            case SOUTH: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case NORTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return -1;
    }
}

