/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.pump.fluid;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.core.liquid.FluidTankBase;
import com.lothrazar.cyclicmagic.core.util.UtilFluid;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityFluidPump
extends TileEntityBaseMachineFluid
implements ITickable,
ITileRedstoneToggle {
    private int transferRate = 150;
    private int needsRedstone = 0;

    public TileEntityFluidPump() {
        super(0);
        this.tank = new FluidTankBase(1000);
    }

    @Override
    public EnumFacing getCurrentFacing() {
        EnumFacing facingTo = super.getCurrentFacing();
        if (facingTo.func_176740_k().func_176720_b()) {
            facingTo = facingTo.func_176734_d();
        }
        return facingTo;
    }

    public void func_73660_a() {
        if (!this.isPowered() && this.onlyRunIfPowered()) {
            return;
        }
        EnumFacing importFromSide = this.getCurrentFacing();
        UtilFluid.tryFillTankFromPosition(this.field_145850_b, this.field_174879_c.func_177972_a(importFromSide), importFromSide.func_176734_d(), this.tank, this.transferRate);
        List<EnumFacing> sidesOut = this.getSidesNotFacing();
        for (EnumFacing exportToSide : sidesOut) {
            TileEntityCableBase cable;
            boolean outputSuccess = UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c.func_177972_a(exportToSide), exportToSide.func_176734_d(), this.tank, this.transferRate);
            if (outputSuccess && this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(exportToSide)) instanceof TileEntityCableBase && (cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(exportToSide))).isFluidPipe()) {
                cable.updateIncomingFluidFace(exportToSide.func_176734_d());
            }
            if (!outputSuccess) continue;
            break;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        compound.func_74768_a("transferRate", this.transferRate);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("transferRate", this.transferRate);
        if (this.transferRate == 0) {
            this.transferRate = 150;
        }
        return super.func_189515_b(compound);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE;

    }
}

