/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.ore;

import com.lothrazar.cyclicmagic.block.ore.OreConfig;
import com.lothrazar.cyclicmagic.core.IHasOreDict;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDimensionOre
extends BlockOre
implements IHasOreDict {
    public OreConfig config = new OreConfig();
    private Item dropped;
    private int droppedMeta;
    private int randomMax;
    private int spawnChance = 0;
    private SpawnType spawn = null;
    private ItemStack smeltOut;
    private String oreDict;

    public BlockDimensionOre() {
        this(null, 0);
    }

    public BlockDimensionOre(Item drop) {
        this(drop, 0);
    }

    public BlockDimensionOre(Item drop, int dmg) {
        this(drop, 0, 1);
    }

    public BlockDimensionOre(Item drop, int dmg, int max) {
        this.dropped = drop;
        this.droppedMeta = dmg;
        this.randomMax = max;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.setHarvestLevel("shovel", 0);
    }

    public BlockDimensionOre setPickaxeHarvestLevel(int h) {
        this.setHarvestLevel("pickaxe", h);
        return this;
    }

    public BlockDimensionOre setSpawnType(SpawnType t, int chance) {
        this.spawn = t;
        this.spawnChance = chance;
        return this;
    }

    public BlockDimensionOre registerSmeltingOutput(Item out) {
        this.smeltOut = new ItemStack(out);
        return this;
    }

    public BlockDimensionOre registerSmeltingOutput(ItemStack out) {
        this.smeltOut = out;
        return this;
    }

    public ItemStack getSmeltingOutput() {
        return this.smeltOut;
    }

    public void registerOreDict(String out) {
        this.oreDict = out;
    }

    @Override
    public String getOreDict() {
        return this.oreDict;
    }

    public void trySpawnTriggeredEntity(World world, BlockPos pos) {
        int rand;
        if (this.spawn != null && world.func_175659_aa() != EnumDifficulty.PEACEFUL && (rand = world.field_73012_v.nextInt(100)) < this.spawnChance) {
            EntityEndermite e = null;
            switch (this.spawn) {
                case ENDERMITE: {
                    e = new EntityEndermite(world);
                    break;
                }
                case SILVERFISH: {
                    e = new EntitySilverfish(world);
                }
            }
            if (e != null) {
                e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)e);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.droppedMeta;
    }

    public int func_149679_a(int fortune, Random random) {
        return super.func_149679_a(fortune, random);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.dropped == null) {
            return Item.func_150898_a((Block)this);
        }
        return this.dropped;
    }

    public int func_149745_a(Random random) {
        if (this.randomMax == 1) {
            return 1;
        }
        return 1 + random.nextInt(this.randomMax);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public String toString() {
        return this.func_149732_F();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum SpawnType {
        ENDERMITE,
        SILVERFISH;

    }
}

