/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary;

import com.lothrazar.cyclicmagic.block.enchantlibrary.QuadrantEnum;
import com.lothrazar.cyclicmagic.block.enchantlibrary.TileEntityLibrary;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBase;
import com.lothrazar.cyclicmagic.core.util.UtilWorld;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockLibraryController
extends BlockBase
implements IHasRecipe {
    private static final int RANGE = 4;
    Block libraryInstance;

    public BlockLibraryController(Block lib) {
        super(Material.field_151575_d);
        this.libraryInstance = lib;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        List<BlockPos> connectors = UtilWorld.getMatchingInRange(world, pos, this.libraryInstance, 4);
        ItemStack playerHeld = player.func_184586_b(hand);
        if (!playerHeld.func_77973_b().equals(Items.field_151134_bR)) {
            return false;
        }
        for (BlockPos p : connectors) {
            TileEntity te = world.func_175625_s(p);
            if (!(te instanceof TileEntityLibrary)) continue;
            TileEntityLibrary lib = (TileEntityLibrary)te;
            QuadrantEnum quad = lib.findMatchingQuadrant(playerHeld);
            if (quad == null) {
                quad = lib.findEmptyQuadrant();
            }
            if (quad == null || !lib.addEnchantmentFromPlayer(player, hand, quad)) continue;
            lib.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), " r ", "rgr", " r ", Character.valueOf('g'), "chestEnder", Character.valueOf('r'), this.libraryInstance);
    }
}

