/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.clockredstone;

import com.lothrazar.cyclicmagic.block.clockredstone.BlockRedstoneClock;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityClock
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    private int timeOff;
    private int timeOn;
    private int power;
    private int needsRedstone = 0;
    private Map<EnumFacing, Boolean> poweredSides = new HashMap<EnumFacing, Boolean>();

    public TileEntityClock() {
        super(0);
        this.timer = 0;
        this.timeOff = 60;
        this.timeOn = 60;
        this.power = 15;
        this.facingResetAllOn();
    }

    public int getPower() {
        return this.power;
    }

    public int getPowerForSide(EnumFacing side) {
        if (this.getSideHasPower(side)) {
            return this.power;
        }
        return 0;
    }

    public boolean getSideHasPower(EnumFacing side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(EnumFacing side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(EnumFacing side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !(newSate.func_177230_c() instanceof BlockRedstoneClock);
    }

    public void func_73660_a() {
        boolean powered;
        if (!this.isRunning()) {
            return;
        }
        if (this.power == 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockRedstoneClock.POWERED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        ++this.timer;
        boolean prevPowered = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRedstoneClock.POWERED);
        if (this.timer < this.timeOff) {
            powered = false;
        } else if (this.timer < this.timeOff + this.timeOn) {
            powered = true;
        } else {
            this.timer = 0;
            powered = false;
        }
        if (prevPowered != powered) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockRedstoneClock.POWERED, (Comparable)Boolean.valueOf(powered)));
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c(), true);
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case POWER: {
                return this.power;
            }
            case TIMER: {
                return this.timer;
            }
            case TOFF: {
                return this.timeOff;
            }
            case TON: {
                return this.timeOn;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case D: {
                return this.getSideField(EnumFacing.DOWN);
            }
            case E: {
                return this.getSideField(EnumFacing.EAST);
            }
            case N: {
                return this.getSideField(EnumFacing.NORTH);
            }
            case S: {
                return this.getSideField(EnumFacing.SOUTH);
            }
            case U: {
                return this.getSideField(EnumFacing.UP);
            }
            case W: {
                return this.getSideField(EnumFacing.WEST);
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case POWER: {
                if (value < 0) {
                    value = 0;
                }
                if (value > 15) {
                    value = 15;
                }
                this.power = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TOFF: {
                this.timeOff = Math.max(value, 1);
                break;
            }
            case TON: {
                this.timeOn = Math.max(value, 1);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
            case D: {
                this.setSideField(EnumFacing.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(EnumFacing.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(EnumFacing.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(EnumFacing.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(EnumFacing.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(EnumFacing.WEST, value % 2);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("off", this.timeOff);
        compound.func_74768_a("on", this.timeOn);
        compound.func_74768_a("power", this.power);
        compound.func_74768_a("redstone", this.needsRedstone);
        for (EnumFacing f : EnumFacing.values()) {
            compound.func_74757_a(f.func_176610_l(), this.poweredSides.get(f).booleanValue());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.timeOff = compound.func_74762_e("off");
        this.timeOn = compound.func_74762_e("on");
        this.power = compound.func_74762_e("power");
        this.needsRedstone = compound.func_74762_e("redstone");
        for (EnumFacing f : EnumFacing.values()) {
            this.poweredSides.put(f, compound.func_74767_n(f.func_176610_l()));
        }
        if (this.detectAllOff()) {
            this.facingResetAllOn();
        }
    }

    private boolean detectAllOff() {
        boolean areAnyOn = false;
        for (EnumFacing f : EnumFacing.values()) {
            areAnyOn = areAnyOn || this.poweredSides.get(f) != false;
        }
        return !areAnyOn;
    }

    private void facingResetAllOn() {
        for (EnumFacing f : EnumFacing.values()) {
            this.poweredSides.put(f, true);
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        TOFF,
        TON,
        POWER,
        REDSTONE,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

