/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.battery;

import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.energy.EnergyCapabilityItemStack;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockBattery
extends ItemBlock {
    public static final String ENERGY = "energy";

    public ItemBlockBattery(Block block) {
        super(block);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xBC000C;
    }

    public double getDurabilityForDisplay(ItemStack item) {
        IEnergyStorage storage = (IEnergyStorage)item.getCapability(CapabilityEnergy.ENERGY, null);
        double energy = storage.getEnergyStored();
        return 1.0 - energy / (double)storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, World player, List<String> tooltip, ITooltipFlag advanced) {
        IEnergyStorage storage = (IEnergyStorage)item.getCapability(CapabilityEnergy.ENERGY, null);
        tooltip.add(storage.getEnergyStored() + "/" + storage.getMaxEnergyStored());
        tooltip.add(UtilChat.lang("tile.battery.tooltip"));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityItemStack(stack, 1000000);
    }
}

