/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.arrowtarget;

import com.lothrazar.cyclicmagic.block.arrowtarget.TileEntityArrowTarget;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArrowTarget
extends BlockBaseHasTile
implements IHasRecipe {
    public static final PropertyBool POWERED = BlockLever.field_176359_b;

    public BlockArrowTarget() {
        super(Material.field_151576_e);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityArrowTarget();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    private int getPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_175625_s(pos) instanceof TileEntityArrowTarget) {
            TileEntityArrowTarget target = (TileEntityArrowTarget)world.func_175625_s(pos);
            return target.getPower();
        }
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "iii", "sos", "iii", Character.valueOf('i'), "nuggetIron", Character.valueOf('o'), Blocks.field_190976_dk, Character.valueOf('s'), Blocks.field_150430_aB);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        double x = entity.field_70165_t - (double)pos.func_177958_n();
        double z = entity.field_70161_v - (double)pos.func_177952_p();
        double xDist = x - 0.5;
        double zDist = z - 0.5;
        if (!world.field_72995_K && Math.abs(zDist) < 1.0 && Math.abs(xDist) < 1.0) {
            EnumFacing side = null;
            if (x > 0.99) {
                side = EnumFacing.EAST;
            } else if (x < 0.0) {
                side = EnumFacing.WEST;
            } else if (z > 0.99) {
                side = EnumFacing.SOUTH;
            } else if (z < 0.0) {
                side = EnumFacing.NORTH;
            }
            double horizDistance = 0.0;
            horizDistance = side == EnumFacing.NORTH || side == EnumFacing.SOUTH ? xDist : zDist;
            double y = entity.field_70163_u - (double)pos.func_177956_o();
            double vertDistance = y - 0.5;
            double distanceToCenter = Math.sqrt(horizDistance * horizDistance + vertDistance * vertDistance);
            int redstone = 16 - Math.min((int)(distanceToCenter * 26.0), 16);
            if (world.func_175625_s(pos) instanceof TileEntityArrowTarget) {
                TileEntityArrowTarget target = (TileEntityArrowTarget)world.func_175625_s(pos);
                target.setPower(redstone);
            }
        }
    }
}

