/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class AnvilRecipeMaker {
    private static final ItemStack ENCHANTED_BOOK = new ItemStack(Items.field_151134_bR);

    private AnvilRecipeMaker() {
    }

    public static List<IRecipeWrapper> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientRegistry ingredientRegistry) {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            AnvilRecipeMaker.getRepairRecipes(recipes, vanillaRecipeFactory);
        }
        catch (RuntimeException e) {
            Log.get().error("Failed to create repair recipes.", (Throwable)e);
        }
        sw.stop();
        Log.get().debug("Registered vanilla repair recipes in {}", (Object)sw);
        sw.reset();
        sw.start();
        try {
            AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, ingredientRegistry);
        }
        catch (RuntimeException e) {
            Log.get().error("Failed to create enchantment recipes.", (Throwable)e);
        }
        sw.stop();
        Log.get().debug("Registered enchantment recipes in {}", (Object)sw);
        return recipes;
    }

    private static void getBookEnchantmentRecipes(List<IRecipeWrapper> recipes, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientRegistry ingredientRegistry) {
        Collection<ItemStack> ingredients = ingredientRegistry.getAllIngredients(ItemStack.class);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValuesCollection();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.func_77956_u()) continue;
            for (Enchantment enchantment : enchantments) {
                if (!enchantment.func_92089_a(ingredient)) continue;
                try {
                    AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, enchantment, ingredient);
                }
                catch (RuntimeException e) {
                    String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient);
                    Log.get().error("Failed to register book enchantment recipes for ingredient: {}", (Object)ingredientInfo, (Object)e);
                }
            }
        }
    }

    private static void getBookEnchantmentRecipes(List<IRecipeWrapper> recipes, IVanillaRecipeFactory vanillaRecipeFactory, Enchantment enchantment, ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        ArrayList perLevelBooks = Lists.newArrayList();
        ArrayList perLevelOutputs = Lists.newArrayList();
        for (int level = 1; level <= enchantment.func_77325_b(); ++level) {
            Map<Enchantment, Integer> enchMap = Collections.singletonMap(enchantment, level);
            ItemStack bookEnchant = ENCHANTED_BOOK.func_77946_l();
            EnchantmentHelper.func_82782_a(enchMap, (ItemStack)bookEnchant);
            if (!item.isBookEnchantable(ingredient, bookEnchant)) continue;
            perLevelBooks.add(bookEnchant);
            ItemStack withEnchant = ingredient.func_77946_l();
            EnchantmentHelper.func_82782_a(enchMap, (ItemStack)withEnchant);
            perLevelOutputs.add(withEnchant);
        }
        if (!perLevelBooks.isEmpty() && !perLevelOutputs.isEmpty()) {
            IRecipeWrapper anvilRecipe = vanillaRecipeFactory.createAnvilRecipe(ingredient, perLevelBooks, perLevelOutputs);
            recipes.add(anvilRecipe);
        }
    }

    private static void getRepairRecipes(List<IRecipeWrapper> recipes, IVanillaRecipeFactory vanillaRecipeFactory) {
        HashMap items = Maps.newHashMap();
        ItemStack repairWood = new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
        items.put(repairWood, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151041_m), new ItemStack(Items.field_151039_o), new ItemStack(Items.field_151053_p), new ItemStack(Items.field_151038_n), new ItemStack(Items.field_151017_I), new ItemStack(Items.field_185159_cQ)}));
        ItemStack repairStone = new ItemStack(Blocks.field_150347_e);
        items.put(repairStone, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151051_r), new ItemStack(Items.field_151018_J)}));
        ItemStack repairLeather = new ItemStack(Items.field_151116_aA);
        items.put(repairLeather, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)Items.field_151024_Q), new ItemStack((Item)Items.field_151027_R), new ItemStack((Item)Items.field_151026_S), new ItemStack((Item)Items.field_151021_T), new ItemStack(Items.field_185160_cR)}));
        ItemStack repairIron = new ItemStack(Items.field_151042_j);
        items.put(repairIron, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151037_a), new ItemStack(Items.field_151019_K), new ItemStack((Item)Items.field_151028_Y), new ItemStack((Item)Items.field_151030_Z), new ItemStack((Item)Items.field_151165_aa), new ItemStack((Item)Items.field_151167_ab), new ItemStack((Item)Items.field_151020_U), new ItemStack((Item)Items.field_151023_V), new ItemStack((Item)Items.field_151022_W), new ItemStack((Item)Items.field_151029_X)}));
        ItemStack repairGold = new ItemStack(Items.field_151043_k);
        items.put(repairGold, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151010_B), new ItemStack(Items.field_151005_D), new ItemStack(Items.field_151006_E), new ItemStack(Items.field_151011_C), new ItemStack(Items.field_151013_M), new ItemStack((Item)Items.field_151169_ag), new ItemStack((Item)Items.field_151171_ah), new ItemStack((Item)Items.field_151149_ai), new ItemStack((Item)Items.field_151151_aj)}));
        ItemStack repairDiamond = new ItemStack(Items.field_151045_i);
        items.put(repairDiamond, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151047_v), new ItemStack(Items.field_151012_L), new ItemStack((Item)Items.field_151161_ac), new ItemStack((Item)Items.field_151163_ad), new ItemStack((Item)Items.field_151173_ae), new ItemStack((Item)Items.field_151175_af)}));
        for (Map.Entry entry : items.entrySet()) {
            ItemStack repairMaterial = (ItemStack)entry.getKey();
            for (ItemStack ingredient : (List)entry.getValue()) {
                ItemStack damaged1 = ingredient.func_77946_l();
                damaged1.func_77964_b(damaged1.func_77958_k());
                ItemStack damaged2 = ingredient.func_77946_l();
                damaged2.func_77964_b(damaged2.func_77958_k() * 3 / 4);
                ItemStack damaged3 = ingredient.func_77946_l();
                damaged3.func_77964_b(damaged3.func_77958_k() * 2 / 4);
                IRecipeWrapper repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(damaged1, Collections.singletonList(repairMaterial), Collections.singletonList(damaged2));
                IRecipeWrapper repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithMaterial);
                recipes.add(repairWithSame);
            }
        }
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        InventoryPlayer fakeInventory = new InventoryPlayer((EntityPlayer)player);
        try {
            ContainerRepair repair = new ContainerRepair(fakeInventory, player.field_70170_p, (EntityPlayer)player);
            ((Slot)repair.field_75151_b.get(0)).func_75215_d(leftStack);
            ((Slot)repair.field_75151_b.get(1)).func_75215_d(rightStack);
            return repair.field_82854_e;
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            Log.get().error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }
}

