/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_plugins.jei.multiblocks.voidminer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.features.VMBlocks;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.ITargetableRegistry;
import com.valkyrieofnight.vlib.legacy.util.helpers.LanguageHelper;
import com.valkyrieofnight.vlib.lib.stack.WeightedStackBase;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class VoidMinerRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final WeightedStackBase output;
    private final String target;
    public final float clearLens;
    public float prefLens = 0.0f;
    private ITargetableRegistry reg;

    public VoidMinerRecipeWrapper(WeightedStackBase stack, ITargetableRegistry reg) {
        this.reg = reg;
        this.output = stack;
        this.inputs = Lists.newArrayList();
        this.inputs.add(Collections.singletonList(new ItemStack((Block)VMBlocks.LASER_LENS, 1, 0)));
        this.inputs.add(this.reg.getLensesOfTarget(this.reg.getPriorityTarget(this.output.getMainStack())));
        this.target = this.reg.getPriorityTarget(stack.getMainStack());
        List<WeightedStackBase> fList = this.reg.getTargetedList(this.target, 1.0f);
        for (WeightedStackBase weightedOreItemStack : fList) {
            if (!weightedOreItemStack.isStackEqual(stack.getMainStack())) continue;
            WeightedStackBase temp = weightedOreItemStack;
            this.prefLens = (float)Math.round((float)weightedOreItemStack.getWeight() / (float)WeightedRandom.func_76272_a(fList) * 10000.0f) / 100.0f;
            break;
        }
        this.clearLens = (float)Math.round((float)stack.getWeight() / (float)WeightedRandom.func_76272_a(this.reg.getList()) * 10000.0f) / 100.0f;
    }

    public List<ItemStack> getClearLens() {
        return this.inputs.get(0);
    }

    public List<ItemStack> getTargetLens() {
        return this.inputs.get(1);
    }

    public ItemStack getOutput() {
        return this.output.getMainStack();
    }

    public ITargetableRegistry getRegistry() {
        return this.reg;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, (List)ImmutableList.of((Object)ImmutableList.of((Object)this.output.getMainStack())));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String lens = LanguageHelper.toLoc((String)"gui.environmentaltech.lens");
        int lensW = minecraft.field_71466_p.func_78256_a(lens);
        String clear = LanguageHelper.toLoc((String)"gui.environmentaltech.clear");
        int clearfW = minecraft.field_71466_p.func_78256_a(clear);
        String perf = LanguageHelper.toLoc((String)"gui.environmentaltech.pref");
        int perfW = minecraft.field_71466_p.func_78256_a(perf);
        String clearPerc = this.clearLens + "%";
        int clearPW = minecraft.field_71466_p.func_78256_a(clearPerc);
        String prefPerc = this.prefLens + "%";
        int prefPW = minecraft.field_71466_p.func_78256_a(prefPerc);
        minecraft.field_71466_p.func_78276_b(clear, 15 - clearfW / 2, 0, EnumDyeColor.BLACK.func_193350_e());
        minecraft.field_71466_p.func_78276_b(clearPerc, 15 - clearPW / 2, 40, EnumDyeColor.BLACK.func_193350_e());
        minecraft.field_71466_p.func_78276_b(perf, 113 - perfW / 2, 0, EnumDyeColor.BLACK.func_193350_e());
        minecraft.field_71466_p.func_78276_b(prefPerc, 113 - prefPW / 2, 40, EnumDyeColor.BLACK.func_193350_e());
    }
}

