/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator.IAttributeApplicator;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.AttributeIDRegistry;
import com.valkyrieofnight.vlib.legacy.util.helpers.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class NBBPlayerData {
    protected GameProfile playerID;
    protected List<AttributeCache> toDisable = new ArrayList<AttributeCache>();

    public NBBPlayerData(@Nonnull GameProfile playerID) {
        this.playerID = playerID;
    }

    public NBBPlayerData() {
    }

    public GameProfile getPlayerID() {
        return this.playerID;
    }

    public void queueDisable(@Nonnull AttributeCache cache) {
        this.removeQueued(cache.getAttribute());
        this.toDisable.add(cache);
    }

    public boolean hasQueued(@Nonnull AttributeCache cache) {
        for (AttributeCache ac : this.toDisable) {
            if (ac.getAttribute() != cache.getAttribute()) continue;
            return true;
        }
        return false;
    }

    public void removeQueued(@Nonnull AttributeID attributeID) {
        for (int i = 0; i < this.toDisable.size(); ++i) {
            AttributeCache ac = this.toDisable.get(i);
            if (ac.getAttribute() != attributeID) continue;
            this.toDisable.remove(i);
        }
    }

    public void checkDisable(BeaconInfo beacon, World world) {
        EntityPlayer ep = world.func_152378_a(this.playerID.getId());
        if (ep != null) {
            for (AttributeCache attributeCache : this.toDisable) {
                IAttributeApplicator app = beacon.getApplicatorRegistry().getApplicator(attributeCache.getAttribute());
                app.onDisableAttribute(attributeCache, world, ep);
            }
        }
    }

    public NBBPlayerData readFromNBT(NBTTagCompound nbt) {
        this.playerID = PlayerUtil.profileFromNBT((NBTTagCompound)nbt.func_74775_l("player"));
        this.toDisable = new ArrayList<AttributeCache>();
        NBTTagList list = nbt.func_150295_c("attribute_caches", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound ttt = list.func_150305_b(i);
            AttributeID atid = AttributeIDRegistry.getInstance().getAttributeIDFromString(ttt.func_74779_i("attribute_id"));
            this.toDisable.add(new AttributeCache(atid, atid.getCalculator().readFinalValueFromNBT(ttt)));
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("player", (NBTBase)PlayerUtil.profileToNBT((GameProfile)this.playerID));
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.toDisable.size(); ++i) {
            AttributeCache atc = this.toDisable.get(i);
            NBTTagCompound ttt = new NBTTagCompound();
            ttt.func_74778_a("attribute_id", atc.getAttribute().toString());
            atc.getAttribute().getCalculator().writeFinalValueToNBT(ttt, atc.getFinalValue());
            list.func_74742_a((NBTBase)ttt);
        }
        nbt.func_74782_a("attribute_caches", (NBTBase)list);
        return nbt;
    }
}

