/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;
import org.cyclops.integrateddynamics.tileentity.TileProxy;

public class ProxyVariableFacade
extends VariableFacadeBase
implements IProxyVariableFacade {
    private final int proxyId;
    private boolean isValidatingVariable = false;
    private boolean isGettingVariable = false;

    public ProxyVariableFacade(boolean generateId, int proxyId) {
        super(generateId);
        this.proxyId = proxyId;
    }

    public ProxyVariableFacade(int id, int proxyId) {
        super(id);
        this.proxyId = proxyId;
    }

    protected TileProxy getProxy(IPartNetwork network) {
        DimPos dimPos = network.getProxy(this.proxyId);
        if (dimPos != null) {
            return (TileProxy)TileHelpers.getSafeTile((DimPos)dimPos, TileProxy.class);
        }
        return null;
    }

    protected IVariable getTargetVariable(IPartNetwork network) {
        TileProxy tile = this.getProxy(network);
        if (tile != null) {
            IVariable<?> variable = tile.getVariable(network);
            return variable;
        }
        return null;
    }

    @Override
    public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
        if (this.isValid()) {
            if (this.isGettingVariable) {
                throw new VariableRecursionException("Detected infinite recursion for variable references.");
            }
            this.isGettingVariable = true;
            IVariable variable = this.getTargetVariable(network);
            this.isGettingVariable = false;
            return variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.proxyId >= 0;
    }

    protected L10NHelpers.UnlocalizedString getProxyNotInNetworkError() {
        return new L10NHelpers.UnlocalizedString("proxy.integrateddynamics.error.proxy_not_in_network", new Object[]{Integer.toString(this.proxyId)});
    }

    protected L10NHelpers.UnlocalizedString getProxyInvalidError() {
        return new L10NHelpers.UnlocalizedString("proxy.integrateddynamics.error.proxy_invalid", new Object[]{Integer.toString(this.proxyId)});
    }

    protected L10NHelpers.UnlocalizedString getProxyInvalidTypeError(IPartNetwork network, IValueType containingValueType, IValueType actualType) {
        return new L10NHelpers.UnlocalizedString("proxy.integrateddynamics.error.proxy_invalid_type", new Object[]{Integer.toString(this.proxyId), new L10NHelpers.UnlocalizedString(containingValueType.getUnlocalizedName(), new Object[0]), new L10NHelpers.UnlocalizedString(actualType.getUnlocalizedName(), new Object[0])});
    }

    @Override
    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError(new L10NHelpers.UnlocalizedString("variable.integrateddynamics.error.invalid_item", new Object[0]));
        } else if (network.getProxy(this.proxyId) == null) {
            validator.addError(this.getProxyNotInNetworkError());
        } else if (this.getTargetVariable(network) == null) {
            validator.addError(this.getProxyInvalidError());
        } else if (!ValueHelpers.correspondsTo(containingValueType, this.getTargetVariable(network).getType())) {
            validator.addError(this.getProxyInvalidTypeError(network, containingValueType, this.getTargetVariable(network).getType()));
        }
        if (this.isValidatingVariable) {
            throw new VariableRecursionException("Detected infinite recursion for variable references.");
        }
        this.isValidatingVariable = true;
        this.getVariable(network);
        this.isValidatingVariable = false;
    }

    @Override
    public IValueType getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    protected String getProxyTooltip() {
        return L10NHelpers.localize((String)"proxy.integrateddynamics.tooltip.proxy_id", (Object[])new Object[]{this.proxyId});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, World world) {
        if (this.isValid()) {
            list.add(this.getProxyTooltip());
        }
        super.addInformation(list, world);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads) {
        if (this.isValid()) {
            quads.addAll(variableModelBaked.getSubModels(VariableModelProviders.PROXY).getBakedModel().func_188616_a(null, null, 0L));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyVariableFacade)) {
            return false;
        }
        ProxyVariableFacade other = (ProxyVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProxyId() != other.getProxyId()) {
            return false;
        }
        if (this.isValidatingVariable() != other.isValidatingVariable()) {
            return false;
        }
        return this.isGettingVariable() == other.isGettingVariable();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProxyVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getProxyId();
        result = result * 59 + (this.isValidatingVariable() ? 79 : 97);
        result = result * 59 + (this.isGettingVariable() ? 79 : 97);
        return result;
    }

    @Override
    public int getProxyId() {
        return this.proxyId;
    }

    public boolean isValidatingVariable() {
        return this.isValidatingVariable;
    }

    public boolean isGettingVariable() {
        return this.isGettingVariable;
    }

    public void setValidatingVariable(boolean isValidatingVariable) {
        this.isValidatingVariable = isValidatingVariable;
    }

    public void setGettingVariable(boolean isGettingVariable) {
        this.isGettingVariable = isGettingVariable;
    }

    @Override
    public String toString() {
        return "ProxyVariableFacade(proxyId=" + this.getProxyId() + ", isValidatingVariable=" + this.isValidatingVariable() + ", isGettingVariable=" + this.isGettingVariable() + ")";
    }

    public static class VariableRecursionException
    extends IllegalArgumentException {
        public VariableRecursionException(String msg) {
            super(msg);
        }
    }
}

