/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeNbt
extends ValueTypeBase<ValueNbt>
implements IValueTypeNullable<ValueNbt> {
    private Set<String> tagBlacklist = Sets.newHashSet();

    public ValueTypeNbt() {
        super("nbt", Helpers.RGBToInt((int)0, (int)170, (int)170), TextFormatting.DARK_AQUA.toString());
    }

    @Override
    public ValueNbt getDefault() {
        return ValueNbt.of(new NBTTagCompound());
    }

    @Override
    public String toCompactString(ValueNbt value) {
        return value.getRawValue().toString();
    }

    @Override
    public String serialize(ValueNbt value) {
        return this.isNull(value) ? "{}" : value.getRawValue().toString();
    }

    @Override
    public ValueNbt deserialize(String value) {
        try {
            return ValueNbt.of(JsonToNBT.func_180713_a((String)value));
        }
        catch (NBTException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public boolean isNull(ValueNbt a) {
        return a.getRawValue().func_186856_d() == 0;
    }

    public NBTTagCompound filterBlacklistedTags(NBTTagCompound tag) {
        boolean copied = false;
        for (String key : this.tagBlacklist) {
            if (!tag.func_74764_b(key)) continue;
            if (!copied) {
                copied = true;
                tag = tag.func_74737_b();
            }
            tag.func_82580_o(key);
        }
        return tag;
    }

    public static class BlacklistChangedCallback
    implements IChangedCallback {
        public void onChanged(Object value) {
            Object[] elements = (String[])value;
            ValueTypes.NBT.tagBlacklist = Sets.newHashSet((Object[])elements);
        }

        public void onRegisteredPostInit(Object value) {
        }
    }

    public static class ValueNbt
    extends ValueBase {
        private final NBTTagCompound value;

        private ValueNbt(NBTTagCompound value) {
            super(ValueTypes.NBT);
            this.value = ValueTypes.NBT.filterBlacklistedTags(value);
        }

        public static ValueNbt of(@Nullable NBTTagCompound value) {
            return value == null ? ValueTypes.NBT.getDefault() : new ValueNbt(value);
        }

        public NBTTagCompound getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueNbt && ((ValueNbt)o).value.equals((Object)this.value);
        }

        public int hashCode() {
            return this.getType().hashCode() + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeNbt.ValueNbt(value=" + this.value + ")";
        }
    }
}

