/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.inventory;

import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.inventory.SlotHideable;
import shetiphian.multistorage.common.item.ItemEnderBag;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

@ChestContainer(isLargeChest=true)
public class ContainerEnderLink
extends Container {
    private TileEntityEnderLinkChest chestTile;
    private IInventory chest;

    public ContainerEnderLink(EntityPlayer player, TileEntityEnderLinkChest tile) {
        this(player, tile.getChest());
        this.chestTile = tile;
        this.chestTile.onContainerOpen(player);
    }

    public ContainerEnderLink(EntityPlayer player, IInventory chest) {
        int slotId;
        this.chest = chest;
        for (slotId = 0; slotId < 54; ++slotId) {
            this.func_75146_a(new SlotHideable(chest, slotId, 0, 0));
        }
        for (slotId = 0; slotId < 27; ++slotId) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, slotId + 9, 0, 0));
        }
        for (slotId = 0; slotId < 9; ++slotId) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, slotId, 0, 0));
        }
    }

    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        int slotCount = this.chest.func_70302_i_();
        return slotCount >= 27 ? 9 : slotCount / 3;
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> func() {
        int slotCount = this.chest.func_70302_i_();
        HashMap<ContainerSection, List<Slot>> map = new HashMap<ContainerSection, List<Slot>>();
        map.put(ContainerSection.CHEST, new ArrayList(this.field_75151_b.subList(0, slotCount)));
        map.put(ContainerSection.INVENTORY, new ArrayList(this.field_75151_b.subList(54, 90)));
        map.put(ContainerSection.INVENTORY_NOT_HOTBAR, new ArrayList(this.field_75151_b.subList(54, 81)));
        map.put(ContainerSection.INVENTORY_HOTBAR, new ArrayList(this.field_75151_b.subList(81, 90)));
        return map;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.chest.func_70302_i_());
    }

    public void func_75142_b() {
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71112_a((Container)this, 0, this.chest.func_70302_i_());
        }
        super.func_75142_b();
    }

    public boolean isParentTile(TileEntityEnderLinkChest tile) {
        return this.chestTile == tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (value != this.chest.func_70302_i_()) {
            String name = this.chest.func_70005_c_();
            String[] parts = name.split("\\.");
            if (parts.length == 2) {
                ChestHelper.setCapacity((World)Minecraft.func_71410_x().field_71441_e, parts[0], parts[1], (byte)value);
            } else if (parts.length == 4) {
                ChestHelper.setCapacity((World)Minecraft.func_71410_x().field_71441_e, parts[2], parts[3], (byte)value);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType >= 0 && dragType < 9 && !(stack = player.field_71071_by.func_70301_a(dragType)).func_190926_b() && stack.func_77973_b() instanceof ItemEnderBag && stack.func_77952_i() > 9) {
            return null;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.chestTile != null) {
            this.chestTile.onContainerClosed(player);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemInSlot = clickedSlot.func_75211_c();
        if (itemInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = itemInSlot.func_77946_l();
        if (slotNumber < 54 ? !this.func_75135_a(itemInSlot, 54, this.field_75151_b.size(), true) : !this.func_75135_a(itemInSlot, 0, this.chest.func_70302_i_(), false)) {
            return ItemStack.field_190927_a;
        }
        if (itemInSlot.func_190916_E() == 0) {
            clickedSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            clickedSlot.func_75218_e();
        }
        if (itemInSlot.func_190916_E() == returnStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return returnStack;
    }

    public IInventory getChestInventory() {
        return this.chest;
    }
}

