/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import shetiphian.core.client.Localization;
import shetiphian.core.common.NameHelper;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

public class ChestInfoHelper {
    private static final ChestInfoHelper INSTANCE = new ChestInfoHelper();

    public static void wailaGetTankInfo(List<String> tooltip, TileEntityEnderLinkChest tile) {
        if (tile == null) {
            return;
        }
        tooltip.add(ChestInfoHelper.formatChestOwner(tile.getOwnerName(), true));
    }

    public static void sendCapacityInfo(EntityPlayer player, TileEntityEnderLinkChest tankTile) {
        String message = INSTANCE.localize("info.multistorage.chest.capacity.txt");
        message = message + " " + ChestHelper.getCapacity(player.func_130014_f_(), tankTile.getOwnerID(), tankTile.getCode());
        INSTANCE.sendInfo(player, message);
    }

    public static void sendLinkError(EntityPlayer player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.multistorage.bag.nolink" + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(EntityPlayer player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static String formatChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + INSTANCE.localize("info.multistorage.chest.public.txt") + "-]\u00a7r" : "";
        }
        String color = !Strings.isNullOrEmpty((String)owner) && owner.startsWith("#") ? "a" : "b";
        return " \u00a7" + color + "[-" + owner + "-]\u00a7r";
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            message = message.replace("<br>", " ");
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentString(message), ChatType.GAME_INFO));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.func_146105_b((ITextComponent)new TextComponentString(line), true);
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        return NameHelper.getDisplayNameFor((String)(ownerID.startsWith("#") ? ownerID.substring(1) : ownerID));
    }
}

