/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;

public class Recipes {
    static List<Ingredient> getWallItems(JsonObject json) {
        List list;
        String wallType;
        if (Values.wallBaseItems.isEmpty()) {
            Configuration.EventHandler.pre_process();
        }
        switch (wallType = JsonUtils.func_151200_h((JsonObject)json, (String)"wallType").toLowerCase()) {
            case "normal": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_NORMAL);
                break;
            }
            case "item": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_ITEM);
                break;
            }
            case "redstone": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_REDSTONE);
                break;
            }
            case "fluid": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_FLUID);
                break;
            }
            case "power_eu": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_POWER_EU);
                break;
            }
            case "power_rf": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_POWER_RF);
                break;
            }
            case "power_caps": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_POWER_CAPS);
                break;
            }
            case "window": {
                list = Values.wallBaseItems.get((Object)BlockVault.EnumType.WALL_WINDOW);
                break;
            }
            default: {
                throw new JsonSyntaxException("Could not build Vault Wall recipe: invalid wallType provided");
            }
        }
        if (list != null) {
            ArrayList<Ingredient> selection = new ArrayList<Ingredient>();
            for (Object item : list) {
                Ingredient ingredient = CraftingHelper.getIngredient(item);
                if (ingredient == null) continue;
                selection.add(ingredient);
            }
            return selection;
        }
        return null;
    }

    public static class VaultColorizeRecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapelessOreRecipe recipe = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new VaultColorizeRecipe(recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public static class VaultColorizeRecipe
        extends ShapelessRecipes {
            public VaultColorizeRecipe(String group, ItemStack output, NonNullList<Ingredient> ingredients) {
                super(group, output, ingredients);
            }

            @Nonnull
            public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
                ItemStack output = this.func_77571_b();
                EnumDyeColor color = null;
                for (int i = 0; i < var1.func_70302_i_(); ++i) {
                    ItemStack stack = var1.func_70301_a(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_192444_dS) continue;
                    color = EnumDyeColor.func_176764_b((int)(stack.func_77952_i() % 16));
                    break;
                }
                if (color != null) {
                    output.func_77983_a("color", (NBTBase)new NBTTagString(color.func_176610_l()));
                    output.func_77983_a("cvalue", (NBTBase)new NBTTagInt(color.field_193351_w));
                }
                return output;
            }
        }
    }

    static class CompoundIngredient
    extends net.minecraftforge.common.crafting.CompoundIngredient {
        CompoundIngredient(Collection<Ingredient> children) {
            super(children);
        }
    }

    public static class VaultCoreIngredient
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            List<Ingredient> list = Recipes.getWallItems(json);
            if (list != null && !list.isEmpty()) {
                return new CompoundIngredient(list);
            }
            throw new JsonSyntaxException("Could not build Vault Wall recipe, either the wall tag is missing,");
        }
    }

    public static class VaultBlockCondition
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            List<Ingredient> list = Recipes.getWallItems(json);
            return () -> Configuration.SETTINGS.VAULT.enableVaultWallRecipes && list != null && !list.isEmpty();
        }
    }
}

