/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.Registry;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.client.renderer.RenderRegistry;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.misc.ProxyCommon;
import shetiphian.multistorage.common.network.NetworkHandler;
import shetiphian.multistorage.modintegration.ModIntegration;

@Mod(modid="multistorage", name="Multi-Storage", version="1.4.10", dependencies="required-after:shetiphiancore@[v3.5.5,);after:terraqueous", updateJSON="https://gist.githubusercontent.com/ShetiPhian/5a4332ca6221ae61ab3c6d531a989f21/raw/MultiStorage", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber
public class MultiStorage {
    @SidedProxy(clientSide="shetiphian.multistorage.client.misc.ProxyClient", serverSide="shetiphian.multistorage.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="multistorage")
    public static MultiStorage INSTANCE;
    public static final String MOD_ID = "multistorage";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Registry.INSTANCE.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        ModIntegration.INSTANCE.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registry.INSTANCE.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        Registry.INSTANCE.registerItems((IForgeRegistry<Item>)event.getRegistry());
        ModIntegration.INSTANCE.register(event.getRegistry());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) throws Exception {
        RenderRegistry.renderingPreInt();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logMultiStorage = event.getModLog();
        Values.minecraftDir = event.getModConfigurationDirectory().getParentFile().getAbsolutePath();
        proxy.renderingPreInt();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Registry.INSTANCE.doRegistration();
        NetworkHandler.initialise();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        new ModIntegration().load();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Configuration.EventHandler.process();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        ChestHelper.INSTANCE.loadChestData();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        ChestHelper.INSTANCE.unloadChestData();
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        Values.logMultiStorage.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    @Nonnull
    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }

    static {
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.enableUniversalBucket();
        }
    }
}

