/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartNetherrocks implements IPartProperties
{
    FYRITE("Fyrite", "ingot", EnumMaterialTier.REGULAR, 16746262, 3, 150, 8.0f, 4.0f, 2.0f, 1.0f, 15, 7, 2.0f),
    MALACHITE("Malachite", "ingot", EnumMaterialTier.REGULAR, 59033, 3, 700, 9.0f, 3.0f, 4.0f, 1.1f, 12, 39, 3.0f),
    ASHSTONE("Ashstone", "gem", EnumMaterialTier.REGULAR, 5264210, 3, 900, 16.0f, 2.0f, 2.0f, 0.9f, 8, 7, 1.0f),
    ILLUMENITE("Illumenite", "ingot", EnumMaterialTier.REGULAR, 16120478, 3, 700, 8.0f, 4.0f, 4.0f, 1.5f, 17, 7, 3.0f),
    DRAGONSTONE("Dragonstone", "gem", EnumMaterialTier.SUPER, 9177344, 4, 4000, 10.0f, 8.0f, 6.0f, 1.2f, 22, 18, 1.0f),
    ARGONITE("Argonite", "ingot", EnumMaterialTier.SUPER, 4128903, 3, 1300, 8.0f, 3.0f, 9.0f, 0.8f, 13, 18, 2.0f);

    public static final String MOD_ID = "netherrocks";
    final String name;
    final String orePrefix;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartNetherrocks(String name, String orePrefix, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.orePrefix = orePrefix;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        String itemName = String.format("%s:%s_%s", MOD_ID, this.name.toLowerCase(), this.orePrefix);
        return new ItemStack(Item.func_111206_d((String)itemName));
    }

    public String getCraftingOreName() {
        return this.orePrefix + this.name;
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartNetherrocks part : EnumPartNetherrocks.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule(MOD_ID, names.toArray(new String[names.size()]), (Object[])EnumPartNetherrocks.values());
        for (EnumPartNetherrocks part : EnumPartNetherrocks.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

