/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartEbonArts implements IPartProperties
{
    ARCANITE("Arcanite", EnumMaterialTier.REGULAR, 5097155, 315, 6.5f, 2.5f, 2.5f, 1.0f, 16, 15, 2.0f),
    KATCHEEN("Katcheen", EnumMaterialTier.SUPER, 14434882, 1600, 8.5f, 4.0f, 4.0f, 1.0f, 22, 20, 2.0f);

    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;

    private EnumPartEbonArts(String name, EnumMaterialTier tier, int color, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        return new ItemStack(Item.func_111206_d((String)("ea:gem/" + this.name().toLowerCase())));
    }

    public String getCraftingOreName() {
        return "";
    }

    public int getHarvestLevel() {
        switch (this.tier) {
            case MUNDANE: {
                return 1;
            }
            case REGULAR: {
                return 2;
            }
            case SUPER: {
                return 3;
            }
        }
        return 0;
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartEbonArts part : EnumPartEbonArts.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("ebon_arts", names.toArray(new String[names.size()]), (Object[])EnumPartEbonArts.values());
        for (EnumPartEbonArts prop : EnumPartEbonArts.values()) {
            if (!enabled[prop.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(prop));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }
}

