/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartCavern implements IPartProperties
{
    MAGNITE("Magnite", EnumMaterialTier.SUPER, 14629168, 3, 10, 100.0f, 11.0f, 5.0f, 0.7f, 10, 50, 3.0f),
    HEXCITE("Hexcite", EnumMaterialTier.SUPER, 0xFFFFFF, 3, 1041, 10.0f, 5.0f, 11.0f, 1.4f, 24, 15, 1.0f);

    public static final String MOD_ID = "cavern";
    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartCavern(String name, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        Item item = Item.func_111206_d((String)"cavern:cave_item");
        return new ItemStack(item, 1, this == MAGNITE ? 1 : (this == HEXCITE ? 2 : 4));
    }

    public String getCraftingOreName() {
        switch (this) {
            case MAGNITE: {
                return "ingotMagnite";
            }
            case HEXCITE: {
                return "gemHexcite";
            }
        }
        return "";
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartCavern part : EnumPartCavern.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule(MOD_ID, names.toArray(new String[names.size()]), (Object[])EnumPartCavern.values());
        for (EnumPartCavern part : EnumPartCavern.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

