/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class RecipeUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();
    private static File RECIPE_DIR = null;

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = new File("../src/main/resources/assets/industrialforegoing/recipes/");
        }
    }

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        RecipeUtils.setupDir();
        if (!RECIPE_DIR.exists() || result.func_190926_b()) {
            return;
        }
        boolean hasGeneratedFrameRecipe = false;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals(MachineCaseItem.INSTANCE)) continue;
            hasGeneratedFrameRecipe = true;
            RecipeUtils.addShapedRecipe(result, "_enderio", RecipeUtils.generateOptionalJson("enderio", "useEnderIOFrames"), RecipeUtils.replaceFrameWith(new FakeItemStack("enderio:item_material", 0), components));
            RecipeUtils.addShapedRecipe(result, "_thermal", RecipeUtils.generateOptionalJson("thermalexpansion", "useTEFrames"), RecipeUtils.replaceFrameWith(new FakeItemStack("thermalexpansion:frame", 0), components));
            RecipeUtils.addShapedRecipe(result, "", RecipeUtils.generateOptionalJson("industrialforegoing", "useOriginalFrames"), components);
            RecipeUtils.addShapedRecipe(result, "_mekanism", RecipeUtils.generateOptionalJson("mekanism", "useMekanismFrames"), RecipeUtils.replaceFrameWith(new FakeItemStack("mekanism:basicblock", 8), components));
            break;
        }
        if (!hasGeneratedFrameRecipe) {
            RecipeUtils.addShapedRecipe(result, "", new HashMap<String, Object>(), components);
        }
    }

    private static Map<String, Object> generateOptionalJson(String modID, String configValueName) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("conditions", Arrays.asList(ImmutableMap.of((Object)"type", (Object)"forge:and", (Object)"values", Arrays.asList(ImmutableMap.of((Object)"type", (Object)"forge:mod_loaded", (Object)"modid", (Object)modID), ImmutableMap.of((Object)"type", (Object)"industrialforegoing:configuration_value", (Object)"value", (Object)configValueName)))));
        return objectMap;
    }

    private static Object[] replaceFrameWith(Object item, Object ... components) {
        Object[] objects = Arrays.copyOf(components, components.length);
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].equals(MachineCaseItem.INSTANCE)) continue;
            objects[i] = item;
        }
        return objects;
    }

    public static void addShapedRecipe(ItemStack result, String nameExtra, Map<String, Object> json, Object ... components) {
        int i;
        RecipeUtils.setupDir();
        if (!RECIPE_DIR.exists() || result.func_190926_b()) {
            return;
        }
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), RecipeUtils.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", RecipeUtils.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + nameExtra + ".json");
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        RecipeUtils.setupDir();
        if (!RECIPE_DIR.exists() || result.func_190926_b()) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals(MachineCaseItem.INSTANCE)) continue;
            components[i] = "IFCORE";
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeUtils.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", RecipeUtils.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof FakeItemStack) {
            FakeItemStack stack = (FakeItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.name);
            ret.put("data", stack.meta);
            return ret;
        }
        if (thing instanceof Item) {
            return RecipeUtils.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return RecipeUtils.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("nbt not implemented");
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public static void generateConstants() {
        if (!RECIPE_DIR.exists()) {
            return;
        }
        ArrayList<Map<Object, Object>> json = new ArrayList<Map<Object, Object>>();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("name", "IFWITHER");
        entry.put("ingredient", ImmutableMap.of((Object)"item", (Object)"minecraft:nether_star", (Object)"data", (Object)0));
        json.add(entry);
        entry = new HashMap();
        entry.put("name", "IFWITHER");
        entry.put("conditions", Arrays.asList(ImmutableMap.of((Object)"type", (Object)"industrialforegoing:configuration_value", (Object)"value", (Object)"machines.wither_builder.HCWither")));
        entry.put("ingredient", ImmutableMap.of((Object)"item", (Object)"minecraft:skull", (Object)"data", (Object)1));
        json.add(entry);
        json.addAll(RecipeUtils.createOreConditionItem("TIER3", "ingotTin", "minecraft:coal_block"));
        json.addAll(RecipeUtils.createOreConditionItem("TIER4", "ingotCopper", "minecraft:red_sandstone"));
        json.addAll(RecipeUtils.createOreConditionItem("TIER5", "ingotBronze", "minecraft:glowstone"));
        json.addAll(RecipeUtils.createOreConditionItem("TIER6", "ingotSilver", "minecraft:iron_block"));
        json.addAll(RecipeUtils.createOreConditionItem("TIER10", "ingotPlatinum", "minecraft:prismarine_shard"));
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Map<String, Object>> createOreConditionItem(String name, String oreDict, String defaultItem) {
        HashMap<String, String> def = new HashMap<String, String>();
        def.put("name", name);
        def.put("ingredient", (String)ImmutableMap.of((Object)"item", (Object)defaultItem, (Object)"data", (Object)0));
        HashMap<String, Object> ore = new HashMap<String, Object>();
        ore.put("name", name);
        ore.put("conditions", Arrays.asList(ImmutableMap.of((Object)"type", (Object)"teslacorelib:ore_dict", (Object)"ore", (Object)oreDict)));
        ore.put("ingredient", ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)oreDict));
        return Arrays.asList(def, ore);
    }

    private static class FakeItemStack {
        private String name;
        private int meta;

        public FakeItemStack(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }
    }
}

