/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class TreeFluidExtractorTile
extends CustomSidedTileEntity {
    private IFluidTank tank;
    private int tick = 0;
    private int id;

    public TreeFluidExtractorTile() {
        super(TreeFluidExtractorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addFluidTank(FluidsRegistry.LATEX, 8000, EnumDyeColor.GRAY, "Latex tank", new BoundingRectangle(17, 25, 18, 54));
    }

    protected boolean supportsAddons() {
        return false;
    }

    protected void innerUpdate() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() == 8000) {
            return;
        }
        if (this.tick % 5 == 0 && BlockUtils.isLog(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()))) {
            WoodLodProgress woodLog = WoodLodProgress.getWoodLogOrDefault(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()));
            this.tank.fill(new FluidStack((Fluid)FluidsRegistry.LATEX, 1), true);
            if (this.id == 0) {
                this.id = this.field_145850_b.field_73012_v.nextInt();
            }
            if (this.field_145850_b.field_73012_v.nextDouble() <= 0.005) {
                woodLog.setProgress(woodLog.getProgress() + 1);
            }
            if (woodLog.getProgress() > 7) {
                woodLog.setProgress(0);
                this.field_145850_b.func_175698_g(this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()));
            }
        }
        ++this.tick;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank(fluidItems, this.tank);
    }

    public boolean getAllowRedstoneControl() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    public static class WoodLodProgress {
        public static List<WoodLodProgress> woodLodProgressList = new ArrayList<WoodLodProgress>();
        private World world;
        private BlockPos blockPos;
        private int progress;
        private int breakID;

        public WoodLodProgress(World world, BlockPos blockPos) {
            this.world = world;
            this.blockPos = blockPos;
            this.progress = 0;
            this.breakID = world.field_73012_v.nextInt();
            woodLodProgressList.add(this);
        }

        public static WoodLodProgress getWoodLogOrDefault(World world, BlockPos pos) {
            for (WoodLodProgress progress : woodLodProgressList) {
                if (!progress.getBlockPos().equals((Object)pos) || !progress.getWorld().equals(world)) continue;
                return progress;
            }
            return new WoodLodProgress(world, pos);
        }

        public static void remove(World world, BlockPos pos) {
            woodLodProgressList.remove(WoodLodProgress.getWoodLogOrDefault(world, pos));
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public int getProgress() {
            return this.progress;
        }

        public int getBreakID() {
            return this.breakID;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public void setBreakID(int breakID) {
            this.breakID = breakID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WoodLodProgress)) {
                return false;
            }
            WoodLodProgress other = (WoodLodProgress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            World this$world = this.getWorld();
            World other$world = other.getWorld();
            if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
                return false;
            }
            BlockPos this$blockPos = this.getBlockPos();
            BlockPos other$blockPos = other.getBlockPos();
            if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
                return false;
            }
            if (this.getProgress() != other.getProgress()) {
                return false;
            }
            return this.getBreakID() == other.getBreakID();
        }

        protected boolean canEqual(Object other) {
            return other instanceof WoodLodProgress;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            World $world = this.getWorld();
            result = result * 59 + ($world == null ? 43 : $world.hashCode());
            BlockPos $blockPos = this.getBlockPos();
            result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
            result = result * 59 + this.getProgress();
            result = result * 59 + this.getBreakID();
            return result;
        }

        public String toString() {
            return "TreeFluidExtractorTile.WoodLodProgress(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ", progress=" + this.getProgress() + ", breakID=" + this.getBreakID() + ")";
        }
    }
}

