/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.FluidTankType;

public class AnimalResourceHarvesterTile
extends WorkingAreaElectricMachine {
    private ItemStackHandler outItems;
    private IFluidTank tank;

    public AnimalResourceHarvesterTile() {
        super(AnimalResourceHarvesterTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addSimpleFluidTank(8000, "tank", EnumDyeColor.WHITE, 50, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                AnimalResourceHarvesterTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output Items", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List animals = this.field_145850_b.func_72872_a(EntityAnimal.class, this.getWorkingArea());
        boolean hasWorked = false;
        for (EntityAnimal living : animals) {
            ItemStack stack;
            if (!ItemStackUtils.isInventoryFull(this.outItems) && living instanceof IShearable && ((IShearable)living).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)this.field_145850_b, living.func_180425_c())) {
                List stacks = ((IShearable)living).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)this.field_145850_b, null, 0);
                for (ItemStack stack2 : stacks) {
                    ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack2, (boolean)false);
                }
                hasWorked = true;
            }
            if (this.tank.getFluidAmount() > 7000) continue;
            FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b);
            player.func_70107_b(living.field_70165_t, living.field_70163_u, living.field_70161_v);
            player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
            if (!living.func_184645_a((EntityPlayer)player, EnumHand.MAIN_HAND) || !(stack = player.func_184586_b(EnumHand.MAIN_HAND)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            this.tank.fill(fluidHandlerItem.drain(Integer.MAX_VALUE, true), true);
            hasWorked = true;
        }
        for (EntitySquid animal : this.field_145850_b.func_72872_a(EntitySquid.class, this.getWorkingArea())) {
            if (ItemStackUtils.isInventoryFull(this.outItems) || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)new ItemStack(Items.field_151100_aR), (boolean)false);
            hasWorked = true;
        }
        return hasWorked ? 1.0f : 0.0f;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank(fluidItems, this.tank);
    }
}

