/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import java.io.File;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.api.boom.ExplosionCustom;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.terrain.TerrainSegment;
import thut.core.common.config.ConfigBase;
import thut.core.common.config.Configure;
import thut.core.common.terrain.ConfigTerrainBuilder;
import thut.core.common.terrain.ConfigTerrainChecker;

public class ConfigHandler
extends ConfigBase {
    private static final String BOOMS = "explosions";
    private static final String BIOMES = "biomes";
    private static final String BLOCKENTITY = "blockentity";
    private static final String AI = "ai";
    private static final String MISC = "misc";
    @Configure(category="explosions")
    private int explosionRadius = 127;
    @Configure(category="explosions")
    private int[] explosionRate = new int[]{2000, 10000};
    @Configure(category="explosions")
    private boolean affectAir = true;
    @Configure(category="explosions")
    private double minBlastEffect = 0.25;
    @Configure(category="biomes")
    public boolean resetAllTerrain = false;
    @Configure(category="biomes")
    public String[] customBiomeMappings = new String[0];
    @Configure(category="ai", needsMcRestart=true)
    public int threadCount = 1;
    @Configure(category="ai", needsMcRestart=true)
    public boolean multithreadedAI = false;
    @Configure(category="blockentity")
    public String[] teblacklist = new String[0];
    @Configure(category="blockentity")
    public boolean autoBlacklistErroredTEs = true;
    @Configure(category="misc")
    public boolean debug = true;

    public ConfigHandler() {
        super(null);
    }

    public ConfigHandler(File configFile) {
        super(configFile, new ConfigHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.populateSettings();
        this.applySettings();
        this.save();
    }

    @Override
    protected void applySettings() {
        ExplosionCustom.MAX_RADIUS = this.explosionRadius;
        ExplosionCustom.AFFECTINAIR = this.affectAir;
        if (this.explosionRate.length == 2) {
            ExplosionCustom.MAXPERTICK = this.explosionRate;
        }
        ExplosionCustom.MINBLASTDAMAGE = (float)this.minBlastEffect;
        TerrainSegment.noLoad = this.resetAllTerrain;
        IBlockEntity.TEBLACKLIST.clear();
        BlockEntityUpdater.autoBlacklist = this.autoBlacklistErroredTEs;
        for (String s : this.teblacklist) {
            if (!s.contains(":")) {
                s = "minecraft:" + s;
            }
            IBlockEntity.TEBLACKLIST.add(s);
            IBlockEntity.TEBLACKLIST.add(s.toLowerCase(Locale.ENGLISH));
        }
        TerrainSegment.biomeCheckers.removeIf(new Predicate<TerrainSegment.ISubBiomeChecker>(){

            @Override
            public boolean test(TerrainSegment.ISubBiomeChecker t) {
                return t instanceof ConfigTerrainChecker;
            }
        });
        ConfigTerrainBuilder.process(this.customBiomeMappings);
        this.multithreadedAI = false;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("thutcore")) {
            this.populateSettings();
            this.applySettings();
            this.save();
        }
    }
}

