/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.tabula.components.Animation;

public interface IModelRenderer<T extends EntityLiving> {
    public static final String DEFAULTPHASE = "idle";
    public static final Vector3 DEFAULTSCALE = Vector3.getNewVector().set(1);

    public void doRender(T var1, double var2, double var4, double var6, float var8, float var9);

    public IPartTexturer getTexturer();

    public IAnimationChanger getAnimationChanger();

    public void setTexturer(IPartTexturer var1);

    public void setAnimationChanger(IAnimationChanger var1);

    default public String getAnimation(Entity entityIn) {
        CapabilityAnimation.IAnimationHolder holder = (CapabilityAnimation.IAnimationHolder)entityIn.getCapability(CapabilityAnimation.CAPABILITY, null);
        if (holder != null) {
            return holder.getPendingAnimation();
        }
        return DEFAULTPHASE;
    }

    public boolean hasAnimation(String var1, Entity var2);

    public void renderStatus(T var1, double var2, double var4, double var6, float var8, float var9);

    default public void setAnimation(String phase, Entity entity) {
        CapabilityAnimation.IAnimationHolder holder = (CapabilityAnimation.IAnimationHolder)entity.getCapability(CapabilityAnimation.CAPABILITY, null);
        if (holder != null) {
            holder.setPendingAnimation(phase);
        }
    }

    public void scaleEntity(Entity var1, IModel var2, float var3);

    public HashMap<String, List<Animation>> getAnimations();

    default public Vector3 getScale() {
        return DEFAULTSCALE;
    }

    default public Vector3 getRotationOffset() {
        return Vector3.empty;
    }

    @Nullable
    default public Vector5 getRotations() {
        return null;
    }

    public static class Vector5 {
        public Vector4 rotations;
        public int time;

        public Vector5() {
            this.time = 0;
            this.rotations = new Vector4();
        }

        public Vector5(Vector4 rotation, int time) {
            this.rotations = rotation;
            this.time = time;
        }

        public Vector5 interpolate(Vector5 v, float time, boolean wrap) {
            if (v.time == 0) {
                return this;
            }
            if (Double.isNaN(this.rotations.x)) {
                this.rotations = new Vector4();
            }
            Vector4 rotDiff = this.rotations.copy();
            if (this.rotations.x == this.rotations.z && this.rotations.z == this.rotations.y && this.rotations.y == this.rotations.w && this.rotations.w == 0.0f) {
                this.rotations.x = 1.0f;
            }
            if (!v.rotations.equals(this.rotations)) {
                rotDiff = v.rotations.subtractAngles(this.rotations);
                rotDiff = this.rotations.addAngles(rotDiff.scalarMult(time));
            }
            if (Double.isNaN(rotDiff.x)) {
                rotDiff = new Vector4(0.0, 1.0, 0.0, 0.0f);
            }
            Vector5 ret = new Vector5(rotDiff, v.time);
            return ret;
        }

        public String toString() {
            return "|r:" + this.rotations + "|t:" + this.time;
        }
    }
}

