/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.lib.CompatWrapper;

public class BiomeDatabase {
    public static HashMap<Biome, BiomeDictionary.Type[]> biomeTypes = new HashMap();
    private static final int INDEX = 17;

    public static boolean contains(Biome b, BiomeDictionary.Type type) {
        return CompatWrapper.isOfType(b, type);
    }

    public static BiomeType getBiome(Biome b) {
        if (b != null && BiomeDatabase.getBiomeName(b).toLowerCase(Locale.ENGLISH).contains("flower")) {
            return BiomeType.FLOWER;
        }
        return BiomeType.NONE;
    }

    public static Biome getBiome(String name) {
        return (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(name));
    }

    public static String getBiome(World world, Vector3 v) {
        int type = v.getBiomeID(world);
        return BiomeDatabase.getNameFromType(type);
    }

    public static String getBiome(World world, Vector3 v, boolean checkIndandVillage) {
        Village village;
        String ret = "";
        if (checkIndandVillage && (village = world.field_72982_D.func_176056_a(new BlockPos(MathHelper.func_76141_d((float)v.intX()), MathHelper.func_76141_d((float)v.intY()), MathHelper.func_76141_d((float)v.intZ())), 2)) != null) {
            return "village";
        }
        Biome biome = v.getBiome(world);
        ret = BiomeDatabase.getBiome((Biome)biome).name;
        return ret;
    }

    public static int getBiomeType(Biome biome) {
        return Biome.func_185362_a((Biome)biome);
    }

    public static int getBiomeType(String name) {
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return (byte)b.getType();
        }
        for (ResourceLocation key : Biome.field_185377_q.func_148742_b()) {
            Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)key);
            if (b == null || !BiomeDatabase.getBiomeName(b).equalsIgnoreCase(name)) continue;
            return BiomeDatabase.getBiomeType(b);
        }
        return BiomeType.NONE.getType();
    }

    public static String getNameFromType(int type) {
        if (type > 255) {
            return BiomeType.getType((int)type).name;
        }
        if (Biome.func_150568_d((int)type) != null) {
            return BiomeDatabase.getBiomeName(Biome.func_150568_d((int)type));
        }
        return "none";
    }

    public static String getReadableNameFromType(int type) {
        if (type > 255) {
            return BiomeType.getType((int)type).readableName;
        }
        if (Biome.func_150568_d((int)type) != null) {
            return BiomeDatabase.getBiomeName(Biome.func_150568_d((int)type));
        }
        return "None " + type;
    }

    public static String getBiomeName(Biome biome) {
        return (String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (int)17);
    }
}

