/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.maths.Vector3;
import thut.lib.CompatWrapper;

public class Transporter {
    private static void doMoveEntity(Entity theEntity, double x, double y, double z, float yaw, float pitch) {
        if (theEntity instanceof EntityPlayerMP) {
            theEntity.func_184210_p();
            ((EntityPlayerMP)theEntity).field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            MinecraftForge.EVENT_BUS.register((Object)new DeSticker((EntityPlayerMP)theEntity));
        } else {
            theEntity.func_70012_b(x, y, z, yaw, pitch);
        }
    }

    public static Entity teleportEntity(Entity entity, Vector3 t2, int dimension, boolean destBlocked) {
        WorldServer world;
        EntityTracker tracker;
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            return entity;
        }
        if (entity.func_184218_aH()) {
            Entity mount = entity.func_184187_bx();
            mount = Transporter.teleportEntity(mount, t2, dimension, false);
            return entity;
        }
        if (dimension != entity.field_71093_bK) {
            entity = Transporter.transferToDimension(entity, t2, dimension);
            for (Entity e : entity.func_184182_bu()) {
                Transporter.transferToDimension(e, t2, dimension);
            }
        }
        int x = t2.intX() >> 4;
        int z = t2.intZ() >> 4;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = z - 1; j <= z + 1; ++j) {
                entity.func_130014_f_().func_72964_e(x, z);
            }
        }
        Transporter.doMoveEntity(entity, t2.x, t2.y, t2.z, entity.field_70177_z, entity.field_70125_A);
        ArrayList passengers = Lists.newArrayList((Iterable)entity.func_184188_bt());
        for (Entity e : passengers) {
            e.func_184210_p();
            Transporter.doMoveEntity(e, t2.x, t2.y, t2.z, e.field_70177_z, e.field_70125_A);
        }
        if (!passengers.isEmpty()) {
            MinecraftForge.EVENT_BUS.register((Object)new ReMounter(entity, dimension, passengers.toArray(new Entity[passengers.size()])));
        }
        if ((tracker = (world = entity.func_184102_h().func_71218_a(dimension)).func_73039_n()).getTrackingPlayers(entity).getClass().getSimpleName().equals("EmptySet")) {
            tracker.func_72786_a(entity);
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerIn = (EntityPlayerMP)entity;
                tracker.func_180245_a(playerIn);
            }
        }
        return entity;
    }

    private static Entity transferToDimension(Entity entity, Vector3 t2, int dimension) {
        int oldDimension = entity.func_130014_f_().field_73011_w.getDimension();
        if (oldDimension == dimension) {
            return entity;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return Transporter.changeDimension(entity, t2, dimension);
        }
        MinecraftServer server = entity.func_130014_f_().func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        TTeleporter teleporter = new TTeleporter(worldServer, t2.x, t2.y, t2.z);
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
        ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)entityPlayerMP, (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj", "ck"});
        entityPlayerMP.func_82242_a(0);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)teleporter);
        if (oldDimension >= 1) {
            worldServer.func_72838_d((Entity)entityPlayerMP);
            worldServer.func_72866_a((Entity)entityPlayerMP, false);
        }
        return entityPlayerMP;
    }

    @Nullable
    public static Entity changeDimension(Entity entityIn, Vector3 t2, int dimensionIn) {
        if (entityIn.field_71093_bK == dimensionIn) {
            return entityIn;
        }
        if (!entityIn.func_130014_f_().field_72995_K && !entityIn.field_70128_L) {
            List passengers = entityIn.func_184188_bt();
            if (!ForgeHooks.onTravelToDimension((Entity)entityIn, (int)dimensionIn)) {
                return null;
            }
            entityIn.func_130014_f_().field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = entityIn.func_184102_h();
            int i = entityIn.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            entityIn.field_71093_bK = dimensionIn;
            if (i == 1 && dimensionIn == 1) {
                worldserver1 = minecraftserver.func_71218_a(0);
                entityIn.field_71093_bK = 0;
            }
            NBTTagCompound tag = new NBTTagCompound();
            entityIn.func_189511_e(tag);
            entityIn.func_130014_f_().func_72900_e(entityIn);
            entityIn.func_70020_e(tag);
            entityIn.field_70128_L = false;
            entityIn.func_130014_f_().field_72984_F.func_76320_a("reposition");
            double d0 = entityIn.field_70165_t;
            double d1 = entityIn.field_70161_v;
            d0 = MathHelper.func_151237_a((double)(d0 * 8.0), (double)(worldserver1.func_175723_af().func_177726_b() + 16.0), (double)(worldserver1.func_175723_af().func_177728_d() - 16.0));
            d1 = MathHelper.func_151237_a((double)(d1 * 8.0), (double)(worldserver1.func_175723_af().func_177736_c() + 16.0), (double)(worldserver1.func_175723_af().func_177733_e() - 16.0));
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            float f = entityIn.field_70177_z;
            Transporter.doMoveEntity(entityIn, d0, entityIn.field_70163_u, d1, 90.0f, 0.0f);
            TTeleporter teleporter = new TTeleporter(worldserver1, t2.x, t2.y, t2.z);
            teleporter.func_180620_b(entityIn, f);
            worldserver.func_72866_a(entityIn, false);
            entityIn.func_130014_f_().field_72984_F.func_76318_c("reloading");
            Entity entity = CompatWrapper.createEntity((World)worldserver1, entityIn);
            if (entity != null) {
                entity.func_180432_n(entityIn);
                entity.field_98038_p = true;
                worldserver1.func_72838_d(entity);
                worldserver1.func_72866_a(entity, true);
                worldserver.func_82742_i();
                worldserver1.func_82742_i();
                MinecraftForge.EVENT_BUS.register((Object)new ReMounter(entity, dimensionIn, passengers.toArray(new Entity[passengers.size()])));
            }
            entityIn.field_70128_L = true;
            entityIn.func_130014_f_().field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            entityIn.func_130014_f_().field_72984_F.func_76319_b();
            return entity;
        }
        return null;
    }

    public static class ReMounter {
        final Entity[] riders;
        final Entity theMount;
        final int dim;
        final long time;

        public ReMounter(Entity mount, int dim, Entity ... entities) {
            this.riders = entities;
            this.theMount = mount;
            this.time = mount.func_130014_f_().func_82737_E();
            this.dim = dim;
        }

        @SubscribeEvent
        public void tick(TickEvent.ServerTickEvent evt) {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            if (this.theMount.field_70128_L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            boolean doneAll = this.theMount.func_130014_f_().func_82737_E() > this.time;
            for (int i = this.riders.length - 1; i >= 0; --i) {
                Entity theEntity = this.riders[i];
                if (theEntity == null || this.dim == theEntity.field_71093_bK) continue;
                doneAll = false;
                if (!(theEntity instanceof EntityPlayerMP)) continue;
                ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)((EntityPlayerMP)theEntity), (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj", "ck"});
                theEntity.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)theEntity, this.dim, (Teleporter)new TTeleporter(theEntity.func_184102_h().func_71218_a(this.dim)));
            }
            int num = 0;
            if (doneAll) {
                for (int i = this.riders.length - 1; i >= 0; --i) {
                    Entity theEntity = this.riders[i];
                    if (theEntity == null) {
                        ++num;
                        continue;
                    }
                    Transporter.doMoveEntity(theEntity, this.theMount.field_70165_t, this.theMount.field_70163_u, this.theMount.field_70161_v, theEntity.field_70177_z, theEntity.field_70125_A);
                    boolean mounted = theEntity.func_184220_m(this.theMount);
                    boolean bl = doneAll = doneAll && mounted;
                    if (!mounted) continue;
                    this.riders[i] = null;
                    ++num;
                }
            }
            if (doneAll || this.riders.length == num) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }

    public static class DeSticker {
        final EntityPlayerMP player;
        final float x0;
        final float y0;
        final float z0;
        final float yaw;
        final int dimension;
        int tick = 0;

        public DeSticker(EntityPlayerMP player) {
            this.player = player;
            this.dimension = player.field_71093_bK;
            this.x0 = (float)player.field_70165_t;
            this.y0 = (float)player.field_70163_u;
            this.z0 = (float)player.field_70161_v;
            this.yaw = player.field_70177_z;
        }

        @SubscribeEvent
        public void logout(PlayerEvent.PlayerLoggedOutEvent evt) {
            if (evt.player.func_110124_au().equals(this.player.func_110124_au())) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }

        @SubscribeEvent
        public void tick(TickEvent.ServerTickEvent evt) {
            if (evt.phase == TickEvent.Phase.START) {
                return;
            }
            boolean done = this.dimension != this.player.field_71093_bK;
            float dx = (float)this.player.field_70165_t - this.x0;
            float dz = (float)this.player.field_70161_v - this.z0;
            float dyaw = this.player.field_70177_z - this.yaw;
            boolean bl = done = done || dx != 0.0f || dz != 0.0f || dyaw != 0.0f;
            if (done) {
                EntityTracker tracker = this.player.func_71121_q().func_73039_n();
                tracker.func_180245_a(this.player);
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            } else if (this.tick % 20 == 0) {
                this.player.field_71135_a.func_147364_a(this.player.field_70165_t, (double)this.y0 + 0.5, this.player.field_70161_v, this.player.field_70177_z, this.player.field_70125_A);
            }
            ++this.tick;
        }
    }

    public static class TTeleporter
    extends Teleporter {
        private final WorldServer worldServerInstance;
        private boolean move = true;
        private double x;
        private double y;
        private double z;

        public TTeleporter(WorldServer world, double x, double y, double z) {
            super(world);
            this.worldServerInstance = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public TTeleporter(WorldServer getWorld) {
            super(getWorld);
            this.worldServerInstance = getWorld;
            this.move = false;
        }

        public void func_180266_a(Entity pEntity, float rotationYaw) {
            if (!this.move) {
                return;
            }
            this.worldServerInstance.func_180495_p(new BlockPos((int)this.x, (int)this.y, (int)this.z));
            Transporter.doMoveEntity(pEntity, this.x, this.y, this.z, pEntity.field_70177_z, pEntity.field_70125_A);
            pEntity.field_70159_w = 0.0;
            pEntity.field_70181_x = 0.0;
            pEntity.field_70179_y = 0.0;
        }

        public void func_85189_a(long par1) {
        }

        public boolean func_85188_a(Entity p_85188_1_) {
            return true;
        }
    }
}

