/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.intwheel.InteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.intwheel.input.KeyBindings;
import mcjty.intwheel.network.PacketHandler;
import mcjty.intwheel.network.PacketPerformAction;
import mcjty.intwheel.network.PacketRequestConfig;
import mcjty.intwheel.playerdata.PlayerProperties;
import mcjty.intwheel.playerdata.PlayerWheelConfiguration;
import mcjty.intwheel.varia.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiWheel
extends GuiScreen {
    private static final int WIDTH = 160;
    private static final int HEIGHT = 160;
    public static final int BUTTON_CONFIG = -2;
    public static final int BUTTON_LEFT = -3;
    public static final int BUTTON_RIGHT = -4;
    private int guiLeft;
    private int guiTop;
    private BlockPos pos;
    private int page = 0;
    private int pages = 1;
    private static final ResourceLocation background = new ResourceLocation("intwheel", "textures/gui/wheel.png");
    private static final ResourceLocation hilight = new ResourceLocation("intwheel", "textures/gui/wheel_hilight.png");
    private static final List<Pair<Integer, Integer>> iconOffsets = new ArrayList<Pair<Integer, Integer>>();

    public GuiWheel() {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        this.pos = mouseOver.field_72313_a == RayTraceResult.Type.BLOCK && mouseOver != null ? mouseOver.func_178782_a() : null;
    }

    private List<String> getActions() {
        return InteractionWheel.interactionWheelImp.getActions((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, this.pos);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 160) / 2;
        this.guiTop = (this.field_146295_m - 160) / 2;
        this.page = 0;
        this.pages = 1;
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestConfig());
    }

    private static boolean isKeyDown(KeyBinding key) {
        int i = key.func_151463_i();
        return i != 0 && i < 256 ? (i < 0 ? Mouse.isButtonDown((int)(i + 100)) : Keyboard.isKeyDown((int)i)) : false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (GuiWheel.isKeyDown(KeyBindings.keyOpenWheel)) {
            this.closeThis();
        } else if (keyCode == 57) {
            ++this.page;
            if (this.page >= this.pages) {
                this.page = 0;
            }
        } else if (typedChar >= 'a' && typedChar <= 'z' || typedChar >= 'A' && typedChar <= 'Z') {
            PlayerWheelConfiguration config = PlayerProperties.getWheelConfig((EntityPlayer)this.field_146297_k.field_71439_g);
            Map<String, Integer> hotkeys = config.getHotkeys();
            List<String> actions = this.getActions();
            for (String action : actions) {
                if (!hotkeys.containsKey(action) || hotkeys.get(action) != keyCode) continue;
                this.performAction(action);
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
                KeyBinding.func_74506_a();
                return;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        List<String> actions = this.getActions();
        int cx = mouseX - this.guiLeft - 80;
        int cy = mouseY - this.guiTop - 80;
        int q = this.getSelectedSection(actions, cx, cy);
        if (q == -2) {
            EntityPlayerSP player = this.field_146297_k.field_71439_g;
            player.openGui((Object)InteractionWheel.instance, 1, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            return;
        }
        if (q == -3) {
            --this.page;
            if (this.page < 0) {
                this.page = this.pages - 1;
                if (this.page < 0) {
                    this.page = 0;
                }
            }
            return;
        }
        if (q == -4) {
            ++this.page;
            if (this.page > this.pages - 1) {
                this.page = 0;
            }
            return;
        }
        if (q == -1) {
            this.closeThis();
        } else if (q < this.getActionSize(actions)) {
            this.performAction(actions, q);
        }
        this.closeThis();
    }

    private void performAction(List<String> actions, int index) {
        String id = actions.get(index + this.page * 8);
        this.performAction(id);
    }

    private void performAction(String id) {
        IWheelAction action = InteractionWheel.registry.get(id);
        if (action != null) {
            boolean extended;
            boolean bl = extended = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (action.performClient((EntityPlayer)this.field_146297_k.field_71439_g, (World)this.field_146297_k.field_71441_e, this.pos, extended)) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPerformAction(this.pos, id, extended));
            }
        }
    }

    private void closeThis() {
        this.field_146297_k.func_147108_a(null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 160, 160);
        List<String> actions = this.getActions();
        int n = this.pages = actions.isEmpty() ? 0 : (actions.size() - 1) / 8 + 1;
        if (this.page >= this.pages) {
            this.page = 0;
        }
        if (this.pages > 1) {
            this.renderPageText(this.page + 1 + " / " + this.pages);
        }
        int cx = mouseX - this.guiLeft - 80;
        int cy = mouseY - this.guiTop - 80;
        int offset = this.getActionSize(actions) / 2;
        int q = this.getSelectedSection(actions, cx, cy);
        if (q == -2) {
            this.highlightConfigButton();
            this.renderTooltipText("Click for configuration");
        } else if (q == -3) {
            this.highlightLeftButton();
            this.renderTooltipText("Go to previous page");
        } else if (q == -4) {
            this.highlightRightButton();
            this.renderTooltipText("Go to next page");
        } else if (q != -1) {
            this.drawSelectedSection(offset, q);
            if (q < this.getActionSize(actions)) {
                this.drawTooltip(actions, q);
            }
        }
        this.drawIcons(actions, offset, q);
    }

    private void drawIcons(List<String> actions, int offset, int q) {
        PlayerWheelConfiguration config = PlayerProperties.getWheelConfig((EntityPlayer)this.field_146297_k.field_71439_g);
        Map<String, Integer> hotkeys = config.getHotkeys();
        for (int i = 0; i < this.getActionSize(actions); ++i) {
            String id = actions.get(i + this.page * 8);
            IWheelAction action = InteractionWheel.registry.get(id);
            if (action == null) continue;
            WheelActionElement element = action.createElement();
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(element.getTexture()));
            int txtw = element.getTxtw();
            int txth = element.getTxth();
            boolean selected = q == i;
            int u = selected ? element.getUhigh() : element.getUlow();
            int v = selected ? element.getVhigh() : element.getVlow();
            int offs = (i - offset + 8) % 8;
            int ox = this.guiLeft + (Integer)iconOffsets.get(offs).getLeft();
            int oy = this.guiTop + (Integer)iconOffsets.get(offs).getRight();
            RenderHelper.drawTexturedModalRect(ox, oy, u, v, 31, 31, txtw, txth);
            if (!selected || !hotkeys.containsKey(id)) continue;
            double angle = Math.PI * 2 * (double)offs / 8.0 - 1.5707963267948966 + 0.39269908169872414;
            int tx = (int)((double)(this.guiLeft + 80) + 86.0 * Math.cos(angle));
            int ty = (int)((double)(this.guiTop + 80) + 86.0 * Math.sin(angle));
            String keyName = Keyboard.getKeyName((int)hotkeys.get(id));
            RenderHelper.renderText(this.field_146297_k, tx - this.field_146297_k.field_71466_p.func_78263_a(keyName.charAt(0)) / 2, ty - this.field_146297_k.field_71466_p.field_78288_b / 2, keyName);
        }
    }

    private void renderTooltipText(String desc) {
        int width = this.field_146297_k.field_71466_p.func_78256_a(desc);
        int x = this.guiLeft + (160 - width) / 2;
        int y = this.guiTop + 160 + 5;
        RenderHelper.renderText(this.field_146297_k, x, y, desc);
    }

    private void renderPageText(String desc) {
        int width = this.field_146297_k.field_71466_p.func_78256_a(desc);
        int x = this.guiLeft + (160 - width) / 2;
        int y = this.guiTop + 90;
        RenderHelper.renderText(this.field_146297_k, x, y, desc);
    }

    private void drawTooltip(List<String> actions, int q) {
        boolean extended = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        String id = actions.get(q + this.page * 8);
        IWheelAction action = InteractionWheel.registry.get(id);
        if (action != null) {
            WheelActionElement element = action.createElement();
            String desc = element.getDescription();
            String sneakDesc = element.getSneakDescription();
            if (extended && sneakDesc != null) {
                desc = sneakDesc;
            }
            this.renderTooltipText(desc);
        }
    }

    private void highlightConfigButton() {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft + 74, this.guiTop + 74, 74, 74, 12, 12);
    }

    private void highlightLeftButton() {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft + 60, this.guiTop + 75, 60, 75, 10, 10);
    }

    private void highlightRightButton() {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft + 90, this.guiTop + 75, 90, 75, 10, 10);
    }

    private void drawSelectedSection(int offset, int q) {
        this.field_146297_k.func_110434_K().func_110577_a(hilight);
        switch ((q - offset + 8) % 8) {
            case 0: {
                this.func_73729_b(this.guiLeft + 78, this.guiTop, 0, 0, 63, 63);
                break;
            }
            case 1: {
                this.func_73729_b(this.guiLeft + 107, this.guiTop + 22, 64, 0, 63, 63);
                break;
            }
            case 2: {
                this.func_73729_b(this.guiLeft + 107, this.guiTop + 78, 128, 0, 63, 63);
                break;
            }
            case 3: {
                this.func_73729_b(this.guiLeft + 78, this.guiTop + 108, 192, 0, 63, 63);
                break;
            }
            case 4: {
                this.func_73729_b(this.guiLeft + 23, this.guiTop + 107, 0, 64, 63, 63);
                break;
            }
            case 5: {
                this.func_73729_b(this.guiLeft, this.guiTop + 78, 64, 64, 63, 63);
                break;
            }
            case 6: {
                this.func_73729_b(this.guiLeft, this.guiTop + 22, 128, 64, 63, 63);
                break;
            }
            case 7: {
                this.func_73729_b(this.guiLeft + 22, this.guiTop, 192, 64, 63, 63);
            }
        }
    }

    private int getActionSize(List<String> actions) {
        int s = actions.size();
        if (s == 0) {
            return s;
        }
        return Math.min(8, s -= this.page * 8);
    }

    private int getSelectedSection(List<String> actions, int cx, int cy) {
        if (Math.abs(cx) < 6 && Math.abs(cy) < 6) {
            return -2;
        }
        if (Math.abs(cy) < 5 && cx > -20 && cx < -10) {
            return -3;
        }
        if (Math.abs(cy) < 5 && cx > 10 && cx < 20) {
            return -4;
        }
        double dist = Math.sqrt(cx * cx + cy * cy);
        if (dist < 37.0 || dist > 80.0) {
            return -1;
        }
        int q = -1;
        if (cx >= 0 && cy < 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 0;
        } else if (cx >= 0 && cy < 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 1;
        } else if (cx >= 0 && cy >= 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 2;
        } else if (cx >= 0 && cy >= 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 3;
        } else if (cx < 0 && cy >= 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 4;
        } else if (cx < 0 && cy >= 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 5;
        } else if (cx < 0 && cy < 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 6;
        } else if (cx < 0 && cy < 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 7;
        }
        int offset = this.getActionSize(actions) / 2;
        return (q + offset) % 8;
    }

    static {
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)86, (Object)8));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)119, (Object)41));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)119, (Object)87));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)87, (Object)119));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)41, (Object)118));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)10, (Object)87));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)9, (Object)41));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)41, (Object)8));
    }
}

