/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel;

import mcjty.intwheel.playerdata.PlayerProperties;
import mcjty.intwheel.playerdata.PlayerWheelConfiguration;
import mcjty.intwheel.playerdata.PropertiesDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(PlayerProperties.PLAYER_WHEEL_CONFIGURATION, null)) {
            event.addCapability(new ResourceLocation("intwheel", "hotkeys"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerProperties.PLAYER_WHEEL_CONFIGURATION, null)) {
            PlayerWheelConfiguration oldStore = (PlayerWheelConfiguration)event.getOriginal().getCapability(PlayerProperties.PLAYER_WHEEL_CONFIGURATION, null);
            PlayerWheelConfiguration newStore = PlayerProperties.getWheelConfig(event.getEntityPlayer());
            newStore.copyFrom(oldStore);
        }
    }
}

