/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Resources;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PlayerUtils {
    public static BiMap<String, UUID> PROFILE_CACHE = HashBiMap.create();
    public static final String BIRTHDAY_BOY_UUID = "10755ea6-9721-467a-8b5c-92adf689072c";

    private PlayerUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean canPlayerSleep(EntityPlayer player) {
        return !player.func_70608_bn() && player.func_70089_S() && player.field_70170_p.func_72820_D() > 12541L && player.field_70170_p.func_72820_D() < 23458L;
    }

    public static boolean isPlayerReal(Entity player) {
        return player != null && player.field_70170_p != null && player.getClass() == EntityPlayerMP.class;
    }

    public static EntityPlayer getPlayerFromUUID(World world, UUID playerID) {
        for (Object playerEntry : world.field_73010_i) {
            EntityPlayer player;
            if (!(playerEntry instanceof EntityPlayer) || !(player = (EntityPlayer)playerEntry).func_110124_au().equals(playerID)) continue;
            return player;
        }
        return null;
    }

    public static String getPlayerNameFromUUID(UUID uuid) {
        if (PROFILE_CACHE.containsValue((Object)uuid)) {
            return (String)PROFILE_CACHE.inverse().get((Object)uuid);
        }
        String name = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "")), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if ("name".equals(json.nextName())) {
                    name = json.nextString();
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.info("Could not get name for {}", uuid);
            name = exception.getMessage();
        }
        return name;
    }

    public static UUID getUUIDFromName(String username) {
        if (PROFILE_CACHE.containsKey((Object)username)) {
            return (UUID)PROFILE_CACHE.get((Object)username);
        }
        UUID uuid = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://api.mojang.com/users/profiles/minecraft/" + username), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if ("id".equals(json.nextName())) {
                    uuid = PlayerUtils.fixStrippedUUID(json.nextString());
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.info("Could not get name for {}", username);
        }
        return uuid;
    }

    public static UUID fixStrippedUUID(String uuidString) {
        return uuidString.length() != 32 ? null : UUID.fromString(uuidString.substring(0, 8) + "-" + uuidString.substring(8, 12) + "-" + uuidString.substring(12, 16) + "-" + uuidString.substring(16, 20) + "-" + uuidString.substring(20, 32));
    }

    public static int getItemCountInInv(EntityPlayer player, Item item) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !stack.func_77973_b().equals(item)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean playerHasItem(EntityPlayer player, Item item, int meta) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !stack.func_77973_b().equals(item) || meta >= 0 && stack.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getStacksFromPlayer(EntityPlayer player, Item item, int meta) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item || meta >= 0 && stack.func_77960_j() != meta) continue;
            items.add(stack);
        }
        return items;
    }

    public static void changeDimension(EntityPlayerMP player, int dimension) {
        PlayerUtils.changeDimension(player, dimension, player.func_184102_h().func_184103_al());
    }

    public static void changeDimension(EntityPlayerMP player, int dimension, PlayerList playerData) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)dimension)) {
            return;
        }
        int oldDim = player.field_71093_bK;
        boolean wasAlive = player.func_70089_S();
        WorldServer worldOld = playerData.func_72365_p().func_71218_a(player.field_71093_bK);
        WorldServer worldNew = playerData.func_72365_p().func_71218_a(dimension);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_71093_bK = dimension;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldOld.func_72973_f((Entity)player);
        EntityUtils.changeWorld((Entity)player, worldOld, worldNew);
        playerData.func_72375_a(player, worldOld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldNew);
        playerData.func_72354_b(player, worldNew);
        playerData.func_72385_f(player);
        if (player.field_70128_L && wasAlive) {
            player.field_70128_L = false;
        }
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayerSP getClientPlayerSP() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendSpamlessMessage(int messageID, ITextComponent message) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        chat.func_146234_a(message, messageID);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlayerInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && mc.field_71441_e != null && mc.field_71439_g.field_70170_p != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static UUID getClientUUID() {
        return PlayerUtils.fixStrippedUUID(Minecraft.func_71410_x().func_110432_I().func_148255_b());
    }

    public static boolean isPlayersBirthdate(EntityPlayer player) {
        return player.func_110124_au().toString().equalsIgnoreCase(BIRTHDAY_BOY_UUID);
    }

    public static boolean isPlayerDamage(DamageSource source) {
        return source != null && source.func_76346_g() instanceof EntityPlayer;
    }

    public static void setPortalTimer(EntityPlayer player, int time) {
        player.field_82153_h = time;
    }

    public static void setSleepTimer(EntityPlayer player, int time) {
        player.field_71076_b = time;
    }

    public static boolean inPortal(EntityPlayer player) {
        return player.field_71087_bX;
    }
}

