/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.core.transform;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import hellfirepvp.astralsorcery.core.ASMTransformationException;
import hellfirepvp.astralsorcery.core.AstralCore;
import hellfirepvp.astralsorcery.core.ClassPatch;
import hellfirepvp.astralsorcery.core.SubClassTransformer;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.tree.ClassNode;

public class AstralPatchTransformer
implements SubClassTransformer {
    private static final String PATCH_PACKAGE = "hellfirepvp.astralsorcery.core.patch";
    private static ClassPatch currentPatch = null;
    private Map<String, List<ClassPatch>> availablePatches = new HashMap<String, List<ClassPatch>>();

    public AstralPatchTransformer() throws IOException {
        FMLLog.info((String)"[AstralTransformer] Loading patches...", (Object[])new Object[0]);
        int loaded = this.loadClassPatches();
        FMLLog.info((String)("[AstralTransformer] Initialized! Loaded " + loaded + " class patches!"), (Object[])new Object[0]);
    }

    private int loadClassPatches() throws IOException {
        ImmutableSet classes = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getTopLevelClassesRecursive(PATCH_PACKAGE);
        LinkedList<Class> patchClasses = new LinkedList<Class>();
        for (Object info : classes) {
            if (!info.getName().startsWith(PATCH_PACKAGE)) continue;
            patchClasses.add(info.load());
        }
        int load = 0;
        for (Class patchClass : patchClasses) {
            if (!ClassPatch.class.isAssignableFrom(patchClass) || Modifier.isAbstract(patchClass.getModifiers())) continue;
            try {
                ClassPatch patch = (ClassPatch)patchClass.newInstance();
                if (!this.availablePatches.containsKey(patch.getClassName())) {
                    this.availablePatches.put(patch.getClassName(), new LinkedList());
                }
                this.availablePatches.get(patch.getClassName()).add(patch);
                ++load;
            }
            catch (Exception exc) {
                throw new IllegalStateException("Could not load ClassPatch: " + patchClass.getSimpleName(), exc);
            }
        }
        if (load == 0) {
            String[] references;
            FMLLog.info((String)"[AstralTransformer] Found 0 Transformers! Trying to recover with direct references...", (Object[])new Object[0]);
            for (String str : references = new String[]{"hellfirepvp.astralsorcery.core.patch.helper.PatchBlockModify", "hellfirepvp.astralsorcery.core.patch.helper.PatchKnockbackEvent", "hellfirepvp.astralsorcery.core.patch.helper.PatchUpdateElytra", "hellfirepvp.astralsorcery.core.patch.helper.PatchModifyEnchantmentLevels", "hellfirepvp.astralsorcery.core.patch.helper.PatchModifyEnchantmentLevelsTooltip", "hellfirepvp.astralsorcery.core.patch.helper.PatchModifyEnchantmentLevelsTooltipEvent", "hellfirepvp.astralsorcery.core.patch.helper.PatchSunBrightnessWorldClient", "hellfirepvp.astralsorcery.core.patch.helper.PatchSunBrightnessWorldCommon"}) {
                try {
                    ClassPatch c = (ClassPatch)Class.forName(str).newInstance();
                    if (!this.availablePatches.containsKey(c.getClassName())) {
                        this.availablePatches.put(c.getClassName(), new LinkedList());
                    }
                    this.availablePatches.get(c.getClassName()).add(c);
                    ++load;
                }
                catch (Exception exc) {
                    FMLLog.warning((String)("Could not load ClassPatch: " + str), (Object[])new Object[0]);
                    exc.printStackTrace();
                }
            }
        }
        return load;
    }

    @Override
    public void transformClassNode(ClassNode cn, String transformedClassName, String obfName) {
        List<ClassPatch> patches;
        if (!this.availablePatches.isEmpty() && (patches = this.availablePatches.get(transformedClassName)) != null && !patches.isEmpty()) {
            FMLLog.info((String)("[AstralTransformer] Transforming " + obfName + " : " + transformedClassName + " with " + patches.size() + " patches!"), (Object[])new Object[0]);
            try {
                for (ClassPatch patch : patches) {
                    if (!patch.canExecuteForSide(AstralCore.side)) {
                        FMLLog.info((String)("[AstralTransformer] Skipping " + patch.getClass().getSimpleName().toUpperCase() + " as it can't be applied for side " + AstralCore.side), (Object[])new Object[0]);
                        continue;
                    }
                    currentPatch = patch;
                    patch.transform(cn);
                    FMLLog.info((String)("[AstralTransformer] Applied patch " + patch.getClass().getSimpleName().toUpperCase()), (Object[])new Object[0]);
                    currentPatch = null;
                }
            }
            catch (Exception exc) {
                throw new ASMTransformationException("Applying ClassPatches failed (ClassName: " + obfName + " - " + transformedClassName + ") - Rethrowing exception!", exc);
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "Patch based transformer";
    }

    @Override
    public void addErrorInformation() {
        if (currentPatch != null) {
            FMLLog.warning((String)("Patcher was in active patch: " + currentPatch.getClass().getSimpleName()), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isTransformRequired(String transformedClassName) {
        return this.availablePatches.containsKey(transformedClassName);
    }
}

