/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.controller.ControllerNoisePlane;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.auxiliary.LiquidStarlightChaliceHandler;
import hellfirepvp.astralsorcery.common.base.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.block.BlockBoreHead;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.tile.ILiquidStarlightPowered;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.base.TileInventoryBase;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.SimpleSingleFluidCapabilityTank;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.VerticalConeBlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.struct.PatternBlockArray;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBore
extends TileInventoryBase
implements IMultiblockDependantTile,
ILiquidStarlightPowered {
    private static int SEGMENT_STARTUP = 60;
    private static int SEGMENT_PREPARATION = 200;
    private SimpleSingleFluidCapabilityTank tank = new SimpleSingleFluidCapabilityTank(1000, EnumFacing.UP);
    private boolean hasMultiblock = false;
    private int operationTicks = 0;
    private int mbStarlight = 0;
    private int productionTimeout = 0;
    private VerticalConeBlockDiscoverer coneBlockDiscoverer;
    private boolean preparationSuccessful = false;
    private float digPercentage = 0.0f;
    private List<BlockPos> digPosResult = null;
    private Object spritePlane = null;
    private Object facingVortexPlane = null;
    private List ctrlEffectNoise = null;

    public TileBore() {
        super(1, EnumFacing.UP);
        this.tank.setAllowInput(false);
    }

    @Override
    protected TileInventoryBase.ItemHandlerTile createNewItemHandler() {
        return new TileInventoryBase.ItemHandlerTileFiltered(this){

            @Override
            public boolean canInsertItem(int slot, ItemStack toAdd, @Nonnull ItemStack existing) {
                return false;
            }
        };
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.ticksExisted & 0x1F) == 0) {
            this.updateMultiblockState();
        }
        if (!this.field_145850_b.field_72995_K) {
            TileChalice tc;
            if (this.mbStarlight <= 12000 && this.getCurrentBoreType() != null && (tc = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, this.func_174877_v().func_177984_a(), TileChalice.class, false)) != null) {
                LiquidStarlightChaliceHandler.requestLiquidStarlightAndTransferTo(this, tc, this.ticksExisted, 400);
            }
            if (!this.consumeLiquid()) {
                if (this.operationTicks > 0) {
                    this.operationTicks -= 10;
                    this.markForUpdate();
                }
                return;
            }
            if (this.getCurrentBoreType() == null) {
                if (this.operationTicks > 0) {
                    this.markForUpdate();
                }
                this.operationTicks = 0;
                return;
            }
            this.handleSetupProgressTick();
            this.markForUpdate();
            if (this.operationTicks >= SEGMENT_PREPARATION) {
                switch (this.getCurrentBoreType()) {
                    case LIQUID: {
                        if (this.coneBlockDiscoverer == null) {
                            this.coneBlockDiscoverer = new VerticalConeBlockDiscoverer(this.func_174877_v().func_177979_c(3));
                        }
                        if (!this.preparationSuccessful) {
                            if (this.ticksExisted % 8 != 0) break;
                            this.attemptDig();
                            break;
                        }
                        if (this.ticksExisted % 32 == 0) {
                            this.checkDigState();
                        }
                        if (!this.preparationSuccessful) break;
                        this.playBoreLiquidEffect();
                        break;
                    }
                    case VORTEX: {
                        if (!this.preparationSuccessful) {
                            if (this.ticksExisted % 8 != 0) break;
                            this.attemptDigVortex();
                            break;
                        }
                        if (this.ticksExisted % 32 == 0) {
                            this.checkVortexDigState();
                        }
                        if (!this.preparationSuccessful) break;
                        this.playBoreVortexEffect();
                    }
                }
            }
        } else if (this.hasMultiblock && this.operationTicks > 0 && this.getCurrentBoreType() != null) {
            this.updateBoreSprite();
            switch (this.getCurrentWorkingSegment()) {
                case STARTUP: {
                    float chance = (float)this.operationTicks / (float)SEGMENT_STARTUP;
                    this.playVortex(chance);
                    this.playArcs(chance);
                    if (this.getCurrentBoreType() != BoreType.VORTEX) break;
                    this.playCoreParticles(chance);
                    break;
                }
                case PREPARATION: {
                    float prepChance = ((float)this.operationTicks - (float)SEGMENT_STARTUP) / ((float)SEGMENT_PREPARATION - (float)SEGMENT_STARTUP);
                    this.playArcs(prepChance);
                    switch (this.getCurrentBoreType()) {
                        case LIQUID: {
                            this.playVortex(1.0f - prepChance);
                            if (this.operationTicks == SEGMENT_PREPARATION) {
                                this.markDigProcess();
                            }
                            if ((double)prepChance <= 0.85) {
                                this.playInnerVortex(Math.max(0.0, (-0.35 + (double)prepChance) * 2.0));
                                break;
                            }
                            double ch = (double)prepChance - 0.85;
                            this.playInnerVortex(1.0 - (ch /= 0.15));
                            break;
                        }
                        case VORTEX: {
                            this.playVortex(1.0f - prepChance * 0.5f);
                            this.playCoreParticles(1.0f - 2.0f * prepChance);
                            this.playVortexCore(prepChance);
                            if (this.operationTicks != SEGMENT_PREPARATION) break;
                            this.vortexExplosion();
                        }
                    }
                    break;
                }
                case PRE_RUN: 
                case PRODUCTION: {
                    switch (this.getCurrentBoreType()) {
                        case LIQUID: {
                            this.playLightbeam();
                            break;
                        }
                        case VORTEX: {
                            this.playVortex(0.5f);
                            this.playLowVortex();
                            this.updateNoisePlane();
                        }
                    }
                    this.playArcs(1.0f);
                }
            }
        }
    }

    private void playBoreVortexEffect() {
        double densityMax;
        AxisAlignedBB boxVortex = new AxisAlignedBB(-3.0, -7.0, -3.0, 3.0, -3.0, 3.0).func_186670_a(this.func_174877_v());
        AxisAlignedBB drawBox = boxVortex.func_186662_g(16.0);
        double boxSizeX = boxVortex.field_72336_d - boxVortex.field_72340_a;
        double boxSizeY = boxVortex.field_72337_e - boxVortex.field_72338_b;
        double boxSizeZ = boxVortex.field_72334_f - boxVortex.field_72339_c;
        double density = densityMax = boxSizeX * boxSizeY * boxSizeZ;
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, boxVortex);
        for (EntityLivingBase e : entities) {
            if (e == null || e.field_70128_L || e instanceof EntityPlayer || e instanceof EntityTechnicalAmbient) continue;
            if ((double)(e.field_70130_N * e.field_70130_N * e.field_70131_O) >= boxSizeX * boxSizeY * boxSizeZ) {
                Vec3d vec3d = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 5.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                if (e.func_174791_d().func_72438_d(vec3d) >= 0.1) {
                    e.func_70634_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 5.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    if (e instanceof EntityDragon) {
                        String prev = this.field_145850_b.func_82736_K().func_82767_a("mobGriefing");
                        this.field_145850_b.func_82736_K().func_82764_b("mobGriefing", "false");
                        e.func_70636_d();
                        this.field_145850_b.func_82736_K().func_82764_b("mobGriefing", prev);
                    }
                }
            }
            if (e instanceof EntityDragon) {
                e.func_193076_bZ().put(RegistryPotions.potionTimeFreeze, new PotionEffect((Potion)RegistryPotions.potionTimeFreeze, 40, 0));
            } else {
                e.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionTimeFreeze, 80, 0));
            }
            density -= (double)(e.field_70130_N * e.field_70130_N * e.field_70131_O);
        }
        this.consumeLiquid(Math.max(0, MathHelper.func_76143_f((double)(Math.abs(density) / densityMax))));
        List draws = this.field_145850_b.func_72872_a(EntityLivingBase.class, drawBox);
        draws.removeAll(entities);
        for (EntityLivingBase e : draws) {
            if (e == null || e.field_70128_L || e instanceof EntityPlayer || e instanceof EntityTechnicalAmbient) continue;
            if (e instanceof EntityDragon) {
                e.func_193076_bZ().put(RegistryPotions.potionTimeFreeze, new PotionEffect((Potion)RegistryPotions.potionTimeFreeze, 80, 0));
            }
            EntityUtils.applyVortexMotion(v -> Vector3.atEntityCorner((Entity)e), v -> {
                if (e instanceof EntityDragon) {
                    e.field_70165_t += v.getX();
                    e.field_70163_u += v.getY();
                    e.field_70161_v += v.getZ();
                    e.field_70159_w = 0.0;
                    e.field_70181_x = 0.0;
                    e.field_70179_y = 0.0;
                } else {
                    e.field_70159_w += v.getX();
                    e.field_70181_x += v.getY() * 2.5;
                    e.field_70179_y += v.getZ();
                }
                return null;
            }, new Vector3(this).addY(-4.5), 48.0, 3.0);
            if (!(e.func_174818_b(this.func_174877_v().func_177982_a(0, -5, 0)) <= 25.0)) continue;
            Vector3 randomBuffer = new Vector3(Math.max(0.0, (boxSizeX - (double)e.field_70130_N) / 2.0), Math.max(0.0, (boxSizeY - (double)e.field_70131_O) / 2.0), Math.max(0.0, (boxSizeZ - (double)e.field_70130_N) / 2.0));
            Vector3 randPos = new Vector3(this).addY(-4.5).add(randomBuffer.getX() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1), randomBuffer.getY() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1), randomBuffer.getZ() * (double)rand.nextFloat() * (double)(rand.nextBoolean() ? 1 : -1));
            e.func_70634_a(randPos.getX(), randPos.getY(), randPos.getZ());
            if (e instanceof EntityDragon) {
                e.func_193076_bZ().put(RegistryPotions.potionTimeFreeze, new PotionEffect((Potion)RegistryPotions.potionTimeFreeze, 80, 0));
            } else {
                e.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionTimeFreeze, 80, 0));
            }
            this.consumeLiquid(2);
        }
    }

    private void playBoreLiquidEffect() {
        if (this.productionTimeout > 0) {
            --this.productionTimeout;
        }
        if (this.productionTimeout <= 0) {
            this.productionTimeout = rand.nextInt(10) + 20;
            Chunk ch = this.field_145850_b.func_175726_f(this.func_174877_v());
            FluidRarityRegistry.ChunkFluidEntry entry = FluidRarityRegistry.getChunkEntry(ch);
            if (entry != null) {
                int mbDrain = rand.nextInt(300) + 300;
                int actMbDrain = Math.min(entry.getMbRemaining(), mbDrain);
                if (entry.isValid() && actMbDrain > 0) {
                    FluidStack drained = entry.tryDrain(actMbDrain, false);
                    if (drained == null || drained.getFluid() == null) {
                        drained = new FluidStack(FluidRegistry.WATER, mbDrain);
                    }
                    List<TileChalice> out = LiquidStarlightChaliceHandler.findNearbyChalicesWithSpaceFor(this, drained);
                    out.removeIf(t -> t.func_174877_v().equals((Object)this.func_174877_v().func_177984_a()));
                    if (!out.isEmpty()) {
                        TileChalice target = out.get(rand.nextInt(out.size()));
                        LiquidStarlightChaliceHandler.doFluidTransfer(this, target, drained.copy());
                        entry.tryDrain(actMbDrain, true);
                    }
                } else {
                    FluidStack drained = new FluidStack(FluidRegistry.WATER, mbDrain);
                    List<TileChalice> out = LiquidStarlightChaliceHandler.findNearbyChalicesWithSpaceFor(this, drained);
                    out.removeIf(t -> t.func_174877_v().equals((Object)this.func_174877_v().func_177984_a()));
                    if (!out.isEmpty()) {
                        TileChalice target = out.get(rand.nextInt(out.size()));
                        LiquidStarlightChaliceHandler.doFluidTransfer(this, target, drained.copy());
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playLowVortex() {
        int i;
        for (i = 0; i < 2; ++i) {
            Vector3 dir = new Vector3((double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1));
            Vector3 v = new Vector3(this).add(0.5, -0.65, 0.5);
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
            particle.gravity(0.004).scale(0.4f).setAlphaMultiplier(1.0f);
            particle.motion(dir.getX(), dir.getY(), dir.getZ());
            particle.setColor(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
        }
        for (i = 0; i < 3; ++i) {
            Vector3 particlePos = new Vector3((float)(this.field_174879_c.func_177958_n() - 4) + rand.nextFloat() * 9.0f, (float)(this.field_174879_c.func_177956_o() - 6) + rand.nextFloat() * 9.0f, (float)(this.field_174879_c.func_177952_p() - 4) + rand.nextFloat() * 9.0f);
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 3.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateNoisePlane() {
        EntityFXFacingSprite spr = (EntityFXFacingSprite)this.facingVortexPlane;
        if ((spr == null || spr.canRemove() || spr.isRemoved()) && this.operationTicks > 0) {
            spr = EntityFXFacingSprite.fromSpriteSheet(SpriteLibrary.spriteStar2, (double)this.func_174877_v().func_177958_n() + 0.5, (float)this.func_174877_v().func_177956_o() - 3.5f, (double)this.func_174877_v().func_177952_p() + 0.5, 2.0f, 2);
            spr.setRefreshFunc(() -> {
                if (this.func_145837_r() || this.getCurrentBoreType() == null || this.operationTicks <= 0) {
                    return false;
                }
                if (this.func_145831_w().field_73011_w == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w == null) {
                    return false;
                }
                return this.func_145831_w().field_73011_w.getDimension() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            });
            EffectHandler.getInstance().registerFX(spr);
            this.facingVortexPlane = spr;
        }
        if (this.ctrlEffectNoise == null) {
            this.ctrlEffectNoise = Lists.newArrayList((Object[])new ControllerNoisePlane[]{new ControllerNoisePlane(1.2f), new ControllerNoisePlane(1.8f), new ControllerNoisePlane(2.4f)});
        }
        for (Object ctrl : this.ctrlEffectNoise) {
            for (int i = 0; i < 3; ++i) {
                EntityFXFacingParticle p = ((ControllerNoisePlane)ctrl).setupParticle();
                p.updatePosition((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 3.5, (double)this.func_174877_v().func_177952_p() + 0.5).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).motion((double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1)).scale(0.15f + rand.nextFloat() * 0.05f).setMaxAge(30 + rand.nextInt(15));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void vortexExplosion() {
        for (int i = 0; i < 140; ++i) {
            Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2, (double)this.field_174879_c.func_177956_o() - 3.5 - (double)0.1f + (double)rand.nextFloat() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2);
            Vector3 dir = new Vector3((double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1));
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.3f + rand.nextFloat() * 0.15f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playVortexCore(float prepChance) {
        float yOffset = -0.5f - 3.0f * Math.min(1.0f, prepChance * 2.0f);
        for (int i = 0; i < 15; ++i) {
            Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2, (double)((float)this.field_174879_c.func_177956_o() + yOffset - 0.1f) + (double)rand.nextFloat() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)0.1f + (double)rand.nextFloat() * 0.2);
            float mul = prepChance <= 0.5f ? 1.0f : 1.0f - prepChance;
            Vector3 dir = new Vector3((double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.035 * (double)mul * (double)(rand.nextBoolean() ? 1 : -1));
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playInnerVortex(double chance) {
        for (int i = 0; i < 12; ++i) {
            if (!((double)rand.nextFloat() < chance)) continue;
            Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() - 0.4 + (double)rand.nextFloat() * 1.8, (double)((float)this.field_174879_c.func_177956_o() - rand.nextFloat() * 3.0f), (double)this.field_174879_c.func_177952_p() - 0.4 + (double)rand.nextFloat() * 1.8);
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
            if (!rand.nextBoolean()) continue;
            p.setColor(new Color(5793279));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void markDigProcess() {
        int x = this.func_174877_v().func_177958_n();
        int z = this.func_174877_v().func_177952_p();
        for (int yy = 0; yy < this.func_174877_v().func_177956_o(); ++yy) {
            BlockPos pos = new BlockPos(x, yy, z);
            IBlockState at = this.field_145850_b.func_180495_p(pos);
            if (!at.func_185895_e() && !at.func_177230_c().isAir(at, (IBlockAccess)this.field_145850_b, pos)) continue;
            for (int i = 0; i < 20; ++i) {
                Vector3 v = new Vector3((double)x + 0.2 + (double)rand.nextFloat() * 0.6, (double)((float)yy + rand.nextFloat()), (double)z + 0.2 + (double)rand.nextFloat() * 0.6);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
                p.setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
                p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
            }
        }
        Vector3 origin = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5);
        Vector3 target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(0);
        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(target, origin, 1.5).setAlphaMultiplier(1.0f);
        beam.setAlphaFunction(EntityComplexFX.AlphaFunction.FADE_OUT);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5).setColorOverlay(new Color(5793279));
    }

    @SideOnly(value=Side.CLIENT)
    private void playCoreParticles(float chance) {
        for (int i = 0; i < 20; ++i) {
            if (!(rand.nextFloat() < chance)) continue;
            Vector3 particlePos = new Vector3((double)((float)(this.field_174879_c.func_177958_n() - 1) + rand.nextFloat() * 3.0f), (double)this.field_174879_c.func_177956_o() - 1.5 + (double)(rand.nextFloat() * 2.0f), (double)((float)(this.field_174879_c.func_177952_p() - 1) + rand.nextFloat() * 3.0f));
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playVortex(float chance) {
        for (int i = 0; i < 20; ++i) {
            if (!(rand.nextFloat() < chance)) continue;
            Vector3 particlePos = new Vector3((float)(this.field_174879_c.func_177958_n() - 3) + rand.nextFloat() * 7.0f, (float)this.field_174879_c.func_177956_o() + rand.nextFloat(), (float)(this.field_174879_c.func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playArcs(float chance) {
        if ((chance == 1.0f || rand.nextFloat() < chance) && rand.nextInt(10) == 0) {
            Vector3 pos = new Vector3(this).add(0.5, 0.5, 0.5);
            Vector3 dir = new Vector3(1, 0, 0).rotate(Math.toRadians(rand.nextFloat() * 360.0f), Vector3.RotAxis.Y_AXIS);
            dir.normalize().multiply(4);
            Vector3 pos1 = pos.clone().add(dir);
            dir = new Vector3(1, 0, 0).rotate(Math.toRadians(rand.nextFloat() * 360.0f), Vector3.RotAxis.Y_AXIS);
            dir.normalize().multiply(4);
            Vector3 pos2 = pos.clone().add(dir);
            EffectHandler.getInstance().lightning(pos1, pos2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playLightbeam() {
        Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() - 2.5 + (double)(rand.nextFloat() * 6.0f), (double)this.field_174879_c.func_177956_o() - 1.2 + (double)rand.nextFloat() * 3.4, (double)this.field_174879_c.func_177952_p() - 2.5 + (double)(rand.nextFloat() * 6.0f));
        Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
        p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
        p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        for (int i = 0; i < 5; ++i) {
            Vector3 v = new Vector3(this).add(0.3 + (double)rand.nextFloat() * 0.4, (double)(-rand.nextFloat()) * 1.7, 0.3 + (double)rand.nextFloat() * 0.4);
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
            particle.gravity(0.004).scale(0.4f).setAlphaMultiplier(1.0f);
            particle.motion(0.0, (double)(-rand.nextFloat()) * 0.015, 0.0);
            particle.setColor(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
        }
        if (this.ticksExisted % 25 != 0) {
            return;
        }
        float yTarget = (float)this.func_174877_v().func_177956_o() * (1.0f - this.digPercentage);
        Vector3 origin = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5);
        Vector3 target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(yTarget);
        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(target, origin, 9.0).setAlphaMultiplier(1.0f);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5);
        yTarget = (float)this.func_174877_v().func_177956_o() * (0.75f - this.digPercentage / 4.0f);
        target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(yTarget);
        origin = origin.clone().add((double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, (double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1));
        beam = EffectHandler.getInstance().lightbeam(target, origin, 0.8).setAlphaMultiplier(1.0f);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5).setColorOverlay(new Color(6987519));
    }

    private boolean consumeLiquid() {
        return this.consumeLiquid(1);
    }

    private boolean consumeLiquid(int amt) {
        if (this.mbStarlight >= amt) {
            this.mbStarlight -= amt;
            return true;
        }
        this.mbStarlight = 0;
        return false;
    }

    private void checkVortexDigState() {
        if (this.digPosResult == null) {
            this.preparationSuccessful = false;
            return;
        }
        List out = this.digPosResult.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty()) {
            this.preparationSuccessful = false;
            this.digPosResult = null;
        } else {
            this.preparationSuccessful = true;
        }
    }

    private void checkDigState() {
        if (this.digPosResult == null) {
            this.preparationSuccessful = false;
            this.digPercentage = 0.0f;
            return;
        }
        List out = this.digPosResult.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty()) {
            this.preparationSuccessful = false;
            this.digPercentage = 0.0f;
            this.digPosResult = null;
        } else {
            this.preparationSuccessful = true;
            this.digPercentage = 1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDigVortex() {
        LinkedList pos = Lists.newLinkedList();
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                for (int yy = -3; yy >= -7; --yy) {
                    pos.add(this.func_174877_v().func_177982_a(xx, yy, zz));
                }
            }
        }
        List out = pos.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty() && this.field_145850_b instanceof WorldServer) {
            BlockDropCaptureAssist.startCapturing();
            try {
                for (BlockPos p2 : out) {
                    IBlockState state = this.field_145850_b.func_180495_p(p2);
                    if (state.func_185904_a().func_76224_d()) continue;
                    MiscUtils.breakBlockWithoutPlayer((WorldServer)this.field_145850_b, p2, state, true, true, false);
                }
            }
            finally {
                double x = (double)this.func_174877_v().func_177958_n() + 0.5;
                double y = (double)this.func_174877_v().func_177956_o() + 1.5;
                double z = (double)this.func_174877_v().func_177952_p() + 0.5;
                for (ItemStack stack : BlockDropCaptureAssist.getCapturedStacksAndStop()) {
                    ItemUtils.dropItem(this.field_145850_b, x, y, z, stack);
                }
            }
        }
        this.digPosResult = pos;
        this.preparationSuccessful = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDig() {
        float downPerc = Math.min(1.0f, this.digPercentage + 0.2f);
        float dst = (float)this.func_174877_v().func_177956_o() * downPerc;
        List<BlockPos> pos = this.coneBlockDiscoverer.tryDiscoverBlocksDown(dst, 5.0f * downPerc);
        List out = pos.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty() && this.field_145850_b instanceof WorldServer) {
            BlockDropCaptureAssist.startCapturing();
            try {
                for (BlockPos p2 : out) {
                    IBlockState state = this.field_145850_b.func_180495_p(p2);
                    if (state.func_185904_a().func_76224_d()) continue;
                    MiscUtils.breakBlockWithoutPlayer((WorldServer)this.field_145850_b, p2, state, true, true, false);
                }
            }
            finally {
                BlockDropCaptureAssist.getCapturedStacksAndStop();
            }
        }
        this.digPercentage = downPerc;
        boolean bl = this.preparationSuccessful = this.digPercentage >= 1.0f;
        if (this.preparationSuccessful && this.digPosResult == null) {
            this.digPosResult = pos;
        }
    }

    private void handleSetupProgressTick() {
        if (!this.hasMultiblock || this.getCurrentBoreType() == null) {
            this.operationTicks = 0;
            return;
        }
        if (this.operationTicks <= SEGMENT_PREPARATION) {
            ++this.operationTicks;
        }
    }

    @Nonnull
    public OperationSegment getCurrentWorkingSegment() {
        if (this.operationTicks == 0) {
            return OperationSegment.INACTIVE;
        }
        if (this.operationTicks <= SEGMENT_STARTUP) {
            return OperationSegment.STARTUP;
        }
        if (this.operationTicks <= SEGMENT_PREPARATION) {
            return OperationSegment.PREPARATION;
        }
        if (!this.preparationSuccessful) {
            return OperationSegment.PRE_RUN;
        }
        return OperationSegment.PRODUCTION;
    }

    @Override
    public boolean canAcceptStarlight(int mbLiquidStarlight) {
        return true;
    }

    @Override
    public void acceptStarlight(int mbLiquidStarlight) {
        this.mbStarlight += mbLiquidStarlight * 2;
        this.markForUpdate();
    }

    private void updateMultiblockState() {
        boolean found = this.getRequiredStructure().matches(this.field_145850_b, this.func_174877_v());
        if (found) {
            found = this.doEmptyCheck();
        }
        boolean update = this.hasMultiblock != found;
        this.hasMultiblock = found;
        if (update) {
            this.markForUpdate();
        }
    }

    private boolean doEmptyCheck() {
        for (int yy = -2; yy <= 2; ++yy) {
            for (int xx = -3; xx <= 3; ++xx) {
                for (int zz = -3; zz <= 3; ++zz) {
                    if (Math.abs(xx) == 3 && Math.abs(zz) == 3) continue;
                    BlockPos at = this.func_174877_v().func_177982_a(xx, yy, zz);
                    if (xx == 0 && zz == 0) {
                        switch (yy) {
                            case -2: {
                                if (this.field_145850_b.func_175623_d(at)) break;
                                return false;
                            }
                        }
                        continue;
                    }
                    if (this.field_145850_b.func_175623_d(at)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private TextureSpritePlane updateBoreSprite() {
        TextureSpritePlane spr = (TextureSpritePlane)this.spritePlane;
        if ((spr == null || spr.canRemove() || spr.isRemoved()) && this.operationTicks > 0) {
            SpriteSheetResource srs;
            switch (this.getCurrentBoreType()) {
                case VORTEX: {
                    srs = SpriteLibrary.spriteVortex1;
                    break;
                }
                default: {
                    srs = SpriteLibrary.spriteHalo3;
                }
            }
            spr = EffectHandler.getInstance().textureSpritePlane(srs, Vector3.RotAxis.Y_AXIS.clone());
            spr.setPosition(new Vector3(this).add(0.5, 0.5, 0.5));
            spr.setNoRotation(45.0f).setAlphaMultiplier(1.0f);
            spr.setRefreshFunc(() -> {
                if (this.func_145837_r() || this.getCurrentBoreType() == null || this.operationTicks <= 0) {
                    return false;
                }
                if (this.func_145831_w().field_73011_w == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w == null) {
                    return false;
                }
                return this.func_145831_w().field_73011_w.getDimension() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            });
            spr.setRenderAlphaFunction((fx, a) -> a * Math.min(1.0f, (float)this.operationTicks / (float)SEGMENT_STARTUP));
            spr.setScale(5.5f);
            this.spritePlane = spr;
        }
        return spr;
    }

    @Nullable
    public BoreType getCurrentBoreType() {
        IBlockState parent = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (parent.func_177230_c() instanceof BlockBoreHead) {
            return (BoreType)((Object)parent.func_177229_b(BlockBoreHead.BORE_TYPE));
        }
        return null;
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternFountain;
    }

    @Override
    protected void onFirstTick() {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeNBT());
        compound.func_74768_a("operation", this.operationTicks);
        compound.func_74757_a("multiblockState", this.hasMultiblock);
        compound.func_74757_a("digState", this.preparationSuccessful);
        compound.func_74776_a("digPerc", this.digPercentage);
        compound.func_74768_a("mbStarlight", this.mbStarlight);
    }

    @Override
    public void writeSaveNBT(NBTTagCompound compound) {
        super.writeSaveNBT(compound);
        compound.func_74768_a("productionTick", this.productionTimeout);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.tank = SimpleSingleFluidCapabilityTank.deserialize(compound.func_74775_l("tank"));
        if (!this.tank.hasCapability(EnumFacing.UP)) {
            this.tank.accessibleSides.add(EnumFacing.UP);
        }
        this.operationTicks = compound.func_74762_e("operation");
        this.hasMultiblock = compound.func_74767_n("multiblockState");
        this.preparationSuccessful = compound.func_74767_n("digState");
        this.digPercentage = compound.func_74760_g("digPerc");
        this.mbStarlight = compound.func_74762_e("mbStarlight");
    }

    @Override
    public void readSaveNBT(NBTTagCompound compound) {
        super.readSaveNBT(compound);
        this.productionTimeout = compound.func_74762_e("productionTick");
    }

    public static enum BoreType implements IStringSerializable
    {
        LIQUID,
        VORTEX;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public ItemStack asStack() {
            return new ItemStack((Block)BlocksAS.blockBoreHead, 1, this.ordinal());
        }
    }

    public static enum OperationSegment {
        INACTIVE,
        STARTUP,
        PREPARATION,
        PRE_RUN,
        PRODUCTION;

    }
}

