/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal;

import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrystalTransmissionNode
extends SimpleTransmissionNode {
    private CrystalProperties properties;
    private float additionalLoss = 1.0f;

    public CrystalTransmissionNode(BlockPos thisPos, CrystalProperties properties) {
        super(thisPos);
        this.properties = properties;
    }

    public CrystalTransmissionNode(BlockPos thisPos) {
        super(thisPos);
    }

    public void updateAdditionalLoss(float loss) {
        this.additionalLoss = loss;
    }

    @Override
    public void onTransmissionTick(World world) {
        TileCrystalLens lens = MiscUtils.getTileAt((IBlockAccess)world, this.getPos(), TileCrystalLens.class, false);
        if (lens != null) {
            lens.onTransmissionTick();
        }
    }

    @Override
    public float getAdditionalTransmissionLossMultiplier() {
        return this.additionalLoss;
    }

    @Override
    public boolean needsTransmissionUpdate() {
        return true;
    }

    @Override
    public CrystalProperties getTransmissionProperties() {
        return this.properties;
    }

    @Override
    public TransmissionClassRegistry.TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.properties = CrystalProperties.readFromNBT(compound);
        this.additionalLoss = compound.func_74760_g("lossMultiplier");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.properties.writeToNBT(compound);
        compound.func_74776_a("lossMultiplier", this.additionalLoss);
    }

    public static class Provider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public IPrismTransmissionNode provideEmptyNode() {
            return new CrystalTransmissionNode(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:CrystalTransmissionNode";
        }
    }
}

