/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.data.DataActiveCelestials;
import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncData;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class SyncDataHolder
implements ITickHandler {
    public static final SyncDataHolder tickInstance = new SyncDataHolder();
    public static final String DATA_CONSTELLATIONS = "AstralConstellations";
    public static final String DATA_LIGHT_CONNECTIONS = "StarlightNetworkConnections";
    public static final String DATA_LIGHT_BLOCK_ENDPOINTS = "StarlightNetworkEndpoints";
    public static final String DATA_TIME_FREEZE_EFFECTS = "TimeFreezeEffects";
    private static Map<String, AbstractData> serverData = new HashMap<String, AbstractData>();
    private static Map<String, AbstractData> clientData = new HashMap<String, AbstractData>();
    private static List<String> dirtyData = new ArrayList<String>();
    private static final Object dirtyLock = new Object();
    private static byte providerCounter = 0;

    private SyncDataHolder() {
    }

    public static SyncDataHolder getTickInstance() {
        return tickInstance;
    }

    public static void register(AbstractData.AbstractDataProvider<? extends AbstractData> provider) {
        AbstractData.Registry.register(provider);
        AbstractData ad = provider.provideNewInstance();
        ad.setProviderId(provider.getProviderId());
        serverData.put(provider.getKey(), ad);
        ad = provider.provideNewInstance();
        ad.setProviderId(provider.getProviderId());
        clientData.put(provider.getKey(), ad);
    }

    public static byte allocateNewId() {
        byte pId = providerCounter;
        providerCounter = (byte)(providerCounter + 1);
        return pId;
    }

    public static <T extends AbstractData> T getDataServer(String key) {
        return (T)serverData.get(key);
    }

    public static <T extends AbstractData> T getDataClient(String key) {
        return (T)clientData.get(key);
    }

    public static <T extends AbstractData> T getData(Side side, String key) {
        switch (side) {
            case CLIENT: {
                return SyncDataHolder.getDataClient(key);
            }
            case SERVER: {
                return SyncDataHolder.getDataServer(key);
            }
        }
        throw new IllegalArgumentException("Side not defined: " + side);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForUpdate(String key) {
        Object object = dirtyLock;
        synchronized (object) {
            if (!dirtyData.contains(key)) {
                dirtyData.add(key);
            }
        }
    }

    public static void syncAllDataTo(EntityPlayer player) {
        PktSyncData dataSync = new PktSyncData(serverData, true);
        PacketChannel.CHANNEL.sendTo((IMessage)dataSync, (EntityPlayerMP)player);
    }

    public static void receiveServerPacket(Map<String, AbstractData> data) {
        for (String key : data.keySet()) {
            AbstractData dat = clientData.get(key);
            if (dat == null) continue;
            dat.handleIncomingData(data.get(key));
        }
    }

    public static void initialize() {
        SyncDataHolder.register(new DataActiveCelestials.Provider(DATA_CONSTELLATIONS));
        SyncDataHolder.register(new DataLightConnections.Provider(DATA_LIGHT_CONNECTIONS));
        SyncDataHolder.register(new DataLightBlockEndpoints.Provider(DATA_LIGHT_BLOCK_ENDPOINTS));
        SyncDataHolder.register(new DataTimeFreezeEffects.Provider(DATA_TIME_FREEZE_EFFECTS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        if (dirtyData.isEmpty()) {
            return;
        }
        HashMap<String, AbstractData> pktData = new HashMap<String, AbstractData>();
        Object object = dirtyLock;
        synchronized (object) {
            for (String s : dirtyData) {
                Object d = SyncDataHolder.getDataServer(s);
                pktData.put(s, (AbstractData)d);
            }
            dirtyData.clear();
        }
        PktSyncData dataSync = new PktSyncData(pktData, false);
        PacketChannel.CHANNEL.sendToAll((IMessage)dataSync);
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Sync Data Holder";
    }
}

