/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.AbstractData;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class DataActiveCelestials
extends AbstractData {
    private Map<Integer, List<IConstellation>> activeConstellations = new HashMap<Integer, List<IConstellation>>();
    private List<Integer> updateRequested = new LinkedList<Integer>();

    @Nullable
    public Collection<IConstellation> getActiveConstellations(int dimId) {
        return this.activeConstellations.get(dimId);
    }

    public void setNewConstellations(int dimId, Collection<IConstellation> constellations) {
        this.activeConstellations.put(dimId, new LinkedList<IConstellation>(constellations));
        this.requestUpdate(dimId);
        this.markDirty();
    }

    private void requestUpdate(int dimId) {
        if (!this.updateRequested.contains(dimId)) {
            this.updateRequested.add(dimId);
        }
        this.markDirty();
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        for (Integer i : this.activeConstellations.keySet()) {
            this.addDimensionConstellations(i, compound);
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        for (Integer i : this.updateRequested) {
            this.addDimensionConstellations(i, compound);
        }
    }

    private void addDimensionConstellations(int dimId, NBTTagCompound mainCompound) {
        NBTTagList list = new NBTTagList();
        Collection<IConstellation> csts = this.getActiveConstellations(dimId);
        if (csts != null) {
            for (IConstellation c : csts) {
                list.func_74742_a((NBTBase)new NBTTagString(c.getUnlocalizedName()));
            }
        }
        mainCompound.func_74782_a(String.valueOf(dimId), (NBTBase)list);
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        for (String dimIdStr : compound.func_150296_c()) {
            int dimId;
            try {
                dimId = Integer.parseInt(dimIdStr);
            }
            catch (Exception exc) {
                AstralSorcery.log.warn("[AstralSorcery] Received ConstellationUpdate packet with a non-integer dimensionId: " + dimIdStr);
                AstralSorcery.log.warn("[AstralSorcery] Skipping...");
                continue;
            }
            NBTTagList list = compound.func_150295_c(dimIdStr, 8);
            LinkedList<IConstellation> toUpdate = new LinkedList<IConstellation>();
            if (list.func_74745_c() != 0) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    String str = list.func_150307_f(i);
                    IConstellation c = ConstellationRegistry.getConstellationByName(str);
                    if (c == null) {
                        AstralSorcery.log.warn("[AstralSorcery] Received unknown constellation from server: " + str);
                        continue;
                    }
                    toUpdate.add(c);
                }
            }
            this.activeConstellations.put(dimId, toUpdate);
        }
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (!(serverData instanceof DataActiveCelestials)) {
            return;
        }
        Map<Integer, List<IConstellation>> update = ((DataActiveCelestials)serverData).activeConstellations;
        for (Map.Entry<Integer, List<IConstellation>> entry : update.entrySet()) {
            this.activeConstellations.put(entry.getKey(), entry.getValue());
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataActiveCelestials> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataActiveCelestials provideNewInstance() {
            return new DataActiveCelestials();
        }
    }
}

