/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;

public class PerkDestructionLowHealth
extends ConstellationPerk {
    private static float digSpeedIncrease = 1.5f;
    private static float damageIncrease = 3.0f;

    public PerkDestructionLowHealth() {
        super("DTR_LOW_HEALTH", ConstellationPerk.Target.ENTITY_ATTACK, ConstellationPerk.Target.PLAYER_HARVEST_SPEED);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        float healthPerc = 1.0f - attacker.func_110143_aJ() / attacker.func_110138_aP();
        this.addAlignmentCharge(attacker, 0.05 * (double)healthPerc);
        return dmgIn * (1.0f + healthPerc * damageIncrease);
    }

    @Override
    public float onHarvestSpeed(EntityPlayer harvester, IBlockState broken, @Nullable BlockPos at, float breakSpeedIn) {
        float healthPerc = 1.0f - harvester.func_110143_aJ() / harvester.func_110138_aP();
        this.addAlignmentCharge(harvester, 0.02 * (double)healthPerc);
        return breakSpeedIn * (1.0f + healthPerc * digSpeedIncrease);
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        digSpeedIncrease = cfg.getFloat(this.getKey() + "DigSpeedIncrease", this.getConfigurationSection(), digSpeedIncrease, 1.0f, 32.0f, "Defines the dig speed multiplier you get additionally to your normal dig speed when being low on health (25% health = 75% of this additional multiplier)");
        damageIncrease = cfg.getFloat(this.getKey() + "DamageIncrease", this.getConfigurationSection(), damageIncrease, 1.0f, 32.0f, "Defines the damage multiplier you get additionally to your normal damage when being low on health (25% health = 75% of this additional multiplier)");
    }
}

